% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CopyNeutralIMA.R
\docType{package}
\name{CopyNeutralIMA-package}
\alias{CopyNeutralIMA}
\alias{CopyNeutralIMA-package}
\title{Reference samples for analysis of IlluminaHumanMethylation arrays.}
\description{
The CopyNeutralIMA package provides a set of 51 samples for
IlluminaHumanMethylation450k arrays and a set of 13 samples for
IlluminaHumanMethylationEPIC arrays.
}
\details{
The package includes two RGChannelSetExtended objects, one with 51 samples
hybridized with the IlluminaHumanMethylation450k array and another one with
13 samples hybridized with the IlluminaHumanMethylationEPIC array.

For the 450k arrays, samples from GEO series 
\href{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE49618}{GSE49618}
\insertCite{GSE49618}{CopyNeutralIMA}, 
\href{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE61441}{GSE61441} 
\insertCite{GSE61441}{CopyNeutralIMA} and 
\href{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE106089}{GSE106089} 
\insertCite{GSE106089}{CopyNeutralIMA} are provided.

For the EPIC arrays, samples from GEO series 
\href{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE86831}{GSE86831}/
\href{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE86833}{GSE86833} #' \insertCite{GSE86831}{CopyNeutralIMA}, 
\href{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE98990}{GSE98990} 
\insertCite{GSE98990}{CopyNeutralIMA} and 
\href{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE100825}{GSE100825} 
\insertCite{GSE100825}{CopyNeutralIMA} are also provided.

The provided samples consist of material from healthy patients with nominally
no copy number aberrations.

Users may use this data package as controls for their copy number profiling 
analysis or for testing other tools.

Check the vignette on how to use these data as control samples for 
\pkg{conumee}.
}
\references{
\insertAllCited{}
}
\author{
\strong{Maintainer}: Xavier Pastor Hostench \email{xavier.pastor@compbio-dev.com}

Authors:
\itemize{
  \item Moritz Przybilla
}

}
