% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariate_methods.R
\name{ddhf}
\alias{ddhf}
\title{ddhf: Greedy independent filtering}
\usage{
ddhf(unadj_p, filterstat, alpha)
}
\arguments{
\item{unadj_p}{Numeric vector of unadjusted p-values.}

\item{filterstat}{Factor to which different hypotheses belong}

\item{alpha}{Significance level at which to apply method}
}
\value{
DDHF multiple testing object
}
\description{
ddhf: Greedy independent filtering
}
\examples{
     sim_df <- du_ttest_sim(20000,0.95, 1.5)
     obj <- ddhf(sim_df$pvalue, sim_df$filterstat, .1)
     sum(rejected_hypotheses(obj))

}
