#' @title Supporting data for MutSeqR package
#' @description
#'  \strong{Package:} MutSeqRData provides example data for MutSeqR.
#'  It includes the following objects:
#'
#' \describe{
#'  \item{\strong{Example import_mut_data:}}{Data frame object containing list of sequenced sites for sample dna00996.1. Used as an example for importing tabular datasets with MutSeqR.}
#' \item{\strong{Example import_mut_data using Custom column names:}}{Data frame object containing list of sequenced sites for sample dna00996.1. Used as an example for importing tabular datasets with MutSeqR when dataset has custom column names.}
#' \item{\strong{Example import_vcf_data:}}{Block compressed VCF file containing list of sequenced sites for sample dna00996.1. Used as an example for importing VCF datasets with MutSeqR.}
#' \item{\strong{Example mutation data:}}{Data frame object containing list of sequenced sites for 24 samples. Unfiltered. Used as an example for filtering mutation data with MutSeqR.}
#' \item{\strong{Example mutation data filtered:}}{Data frame object containing the filtered list of sequenced sites for 24 samples. Used as an example for downstream MutSeqR functions.}
#' \item{\strong{Precalculated Depth at Base 6 Resolution:}}{Data frame object containing the pre-calculated total depth values for each sample at 6-base subtype resolution. Used as an example in calculate_mf()}
#' \item{\strong{Precalculated Depth at Base 12 Resolution:}}{Data frame object containing the pre-calculated total depth values for each sample at 12-base subtype resolution. Used as a reference for users.}
#' \item{\strong{Precalculated Depth at Base 96 Resolution:}}{Data frame object containing the pre-calculated total depth values for each sample at 96-base subtype resolution. Used as a reference for users.}
#' \item{\strong{Precalculated Depth at Base 192 Resolution:}}{Data frame object containing the pre-calculated total depth values for each sample at 192-base subtype resolution. Used as a reference for users.}}
#' @docType package
#' @name MutSeqRData
#' @rdname MutSeqRData
#' @format NULL
#' @return NULL
#' @keywords utilities
NULL
