/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.io.ByteArrayUtil;
import info.aduna.iteration.LookAheadIteration;
import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.sail.nativerdf.ValueStore;
import org.openrdf.sail.nativerdf.btree.RecordIterator;
import org.openrdf.sail.nativerdf.model.NativeValue;

class NativeStatementIterator
extends LookAheadIteration<Statement, IOException> {
    private final RecordIterator btreeIter;
    private final ValueStore valueStore;

    public NativeStatementIterator(RecordIterator btreeIter, ValueStore valueStore) throws IOException {
        this.btreeIter = btreeIter;
        this.valueStore = valueStore;
    }

    @Override
    public Statement getNextElement() throws IOException {
        byte[] nextValue = this.btreeIter.next();
        if (nextValue == null) {
            return null;
        }
        int subjID = ByteArrayUtil.getInt(nextValue, 0);
        Resource subj = (Resource)((Object)this.valueStore.getValue(subjID));
        int predID = ByteArrayUtil.getInt(nextValue, 4);
        URI pred = (URI)((Object)this.valueStore.getValue(predID));
        int objID = ByteArrayUtil.getInt(nextValue, 8);
        NativeValue obj = this.valueStore.getValue(objID);
        Resource context = null;
        int contextID = ByteArrayUtil.getInt(nextValue, 12);
        if (contextID != 0) {
            context = (Resource)((Object)this.valueStore.getValue(contextID));
        }
        return this.valueStore.createStatement(subj, pred, obj, context);
    }

    @Override
    protected void handleClose() throws IOException {
        super.handleClose();
        this.btreeIter.close();
    }
}

