/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.config;

import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailFactory;
import org.openrdf.sail.config.SailImplConfig;
import org.openrdf.sail.rdbms.RdbmsStore;
import org.openrdf.sail.rdbms.config.RdbmsStoreConfig;

public class RdbmsStoreFactory
implements SailFactory {
    public static final String SAIL_TYPE = "openrdf:RdbmsStore";

    @Override
    public String getSailType() {
        return SAIL_TYPE;
    }

    @Override
    public RdbmsStoreConfig getConfig() {
        return new RdbmsStoreConfig();
    }

    @Override
    public RdbmsStore getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        if (config instanceof RdbmsStoreConfig) {
            RdbmsStoreConfig rdbmsConfig = (RdbmsStoreConfig)config;
            String jdbcDriver = rdbmsConfig.getJdbcDriver();
            String url = rdbmsConfig.getUrl();
            String user = rdbmsConfig.getUser();
            String password = rdbmsConfig.getPassword();
            RdbmsStore store = new RdbmsStore(jdbcDriver, url, user, password);
            store.setMaxNumberOfTripleTables(rdbmsConfig.getMaxTripleTables());
            return store;
        }
        throw new IllegalArgumentException("Supplied config objects should be an RdbmsStoreConfig, is: " + config.getClass());
    }
}

