/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.managers;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrdf.sail.rdbms.managers.BNodeManager;
import org.openrdf.sail.rdbms.managers.HashManager;
import org.openrdf.sail.rdbms.managers.LiteralManager;
import org.openrdf.sail.rdbms.managers.PredicateManager;
import org.openrdf.sail.rdbms.managers.UriManager;
import org.openrdf.sail.rdbms.schema.IdSequence;
import org.openrdf.sail.rdbms.schema.TripleTable;
import org.openrdf.sail.rdbms.schema.ValueTableFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripleTableManager {
    private static final String DEFAULT_TABLE_PREFIX = "TRIPLES";
    private static final String OTHER_TRIPLES_TABLE = "TRIPLES";
    private static final boolean USE_THREAD = true;
    public static int MAX_TABLES = Integer.MAX_VALUE;
    public static final boolean INDEX_TRIPLES = true;
    public Number OTHER_PRED;
    private BNodeManager bnodes;
    private boolean closed;
    private Connection conn;
    private ValueTableFactory factory;
    private Thread initThread;
    private LiteralManager literals;
    private Logger logger = LoggerFactory.getLogger(TripleTableManager.class);
    private PredicateManager predicates;
    private LinkedList<TripleTable> queue = new LinkedList();
    private Pattern tablePrefix = Pattern.compile("\\W(\\w*)\\W*$");
    private Map<Number, TripleTable> tables = new HashMap<Number, TripleTable>();
    private UriManager uris;
    private HashManager hashes;
    private int maxTables = MAX_TABLES;
    private boolean indexingTriples = true;
    private IdSequence ids;
    Exception exc;

    public TripleTableManager(ValueTableFactory factory) {
        this.factory = factory;
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public void setIdSequence(IdSequence ids) {
        this.ids = ids;
        this.OTHER_PRED = ids.idOf(-1L);
    }

    public void setPredicateManager(PredicateManager predicates) {
        this.predicates = predicates;
    }

    public void setBNodeManager(BNodeManager bnodeTable) {
        this.bnodes = bnodeTable;
    }

    public void setLiteralManager(LiteralManager literalTable) {
        this.literals = literalTable;
    }

    public void setUriManager(UriManager uriTable) {
        this.uris = uriTable;
    }

    public void setHashManager(HashManager hashes) {
        this.hashes = hashes;
    }

    public int getMaxNumberOfTripleTables() {
        if (this.maxTables == Integer.MAX_VALUE) {
            return 0;
        }
        return this.maxTables + 1;
    }

    public void setMaxNumberOfTripleTables(int max) {
        this.maxTables = max < 1 ? MAX_TABLES : max - 1;
    }

    public boolean isIndexingTriples() {
        return this.indexingTriples;
    }

    public void setIndexingTriples(boolean indexingTriples) {
        this.indexingTriples = indexingTriples;
    }

    public void initialize() throws SQLException {
        this.tables.putAll(this.findPredicateTables());
        this.initThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TripleTableManager.this.initThread();
                }
                catch (Exception e) {
                    TripleTableManager.this.exc = e;
                    TripleTableManager.this.logger.error(e.toString(), e);
                }
            }
        }, "table-initialize");
        this.initThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        this.closed = true;
        LinkedList<TripleTable> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.notify();
        }
        Iterator<Map.Entry<Number, TripleTable>> iter = this.tables.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Number, TripleTable> next = iter.next();
            TripleTable table = next.getValue();
            if (table.isEmpty()) {
                this.predicates.remove(next.getKey());
                table.drop();
                iter.remove();
            }
            table.close();
        }
    }

    public void createTripleIndexes() throws SQLException {
        this.indexingTriples = true;
        for (TripleTable table : this.tables.values()) {
            if (table.isIndexed()) continue;
            table.createIndex();
        }
    }

    public void dropTripleIndexes() throws SQLException {
        this.indexingTriples = false;
        for (TripleTable table : this.tables.values()) {
            if (!table.isIndexed()) continue;
            table.dropIndex();
        }
    }

    public String findTableName(Number pred) throws SQLException {
        return this.getPredicateTable(pred).getNameWhenReady();
    }

    public synchronized TripleTable getExistingTable(Number pred) {
        if (this.tables.containsKey(pred)) {
            return this.tables.get(pred);
        }
        return this.tables.get(this.OTHER_PRED);
    }

    public synchronized Collection<Number> getPredicateIds() {
        return new ArrayList<Number>(this.tables.keySet());
    }

    public synchronized TripleTable getPredicateTable(Number pred) throws SQLException {
        assert (pred.longValue() != 0L);
        assert (pred.equals(this.ids.idOf(pred)));
        if (this.tables.containsKey(pred)) {
            return this.tables.get(pred);
        }
        if (this.tables.containsKey(this.OTHER_PRED)) {
            return this.tables.get(this.OTHER_PRED);
        }
        String tableName = this.getNewTableName(pred);
        if (this.tables.size() >= this.maxTables) {
            tableName = "TRIPLES";
        }
        TripleTable table = this.factory.createTripleTable(this.conn, tableName);
        table.setIdSequence(this.ids);
        if (this.tables.size() >= this.maxTables) {
            table.setPredColumnPresent(true);
            this.initTable(table);
            this.tables.put(this.OTHER_PRED, table);
        } else {
            this.initTable(table);
            this.tables.put(pred, table);
        }
        return table;
    }

    public synchronized String getTableName(Number pred) throws SQLException {
        if (this.tables.containsKey(pred)) {
            return this.tables.get(pred).getNameWhenReady();
        }
        if (this.tables.containsKey(this.OTHER_PRED)) {
            return this.tables.get(this.OTHER_PRED).getNameWhenReady();
        }
        return null;
    }

    public void removed(int count, boolean locked) throws SQLException {
        String condition = null;
        if (locked) {
            condition = this.getExpungeCondition();
        }
        if (this.hashes != null) {
            condition = this.hashes.removedStatements(count, condition) ? this.hashes.getExpungeCondition() : null;
        }
        if (condition != null) {
            this.bnodes.removedStatements(condition);
            this.uris.removedStatements(condition);
            this.literals.removedStatements(condition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> findAllTables() throws SQLException {
        HashSet<String> tables = new HashSet<String>();
        DatabaseMetaData metaData = this.conn.getMetaData();
        String c = null;
        String s = null;
        String n = null;
        String[] TYPE_TABLE = new String[]{"TABLE"};
        ResultSet rs = metaData.getTables(c, s, n, TYPE_TABLE);
        try {
            while (rs.next()) {
                String tableName = rs.getString(3);
                tables.add(tableName);
            }
            HashSet<String> hashSet = tables;
            return hashSet;
        }
        finally {
            rs.close();
        }
    }

    protected Map<Number, TripleTable> findPredicateTables() throws SQLException {
        HashMap<Number, TripleTable> tables = new HashMap<Number, TripleTable>();
        Set<String> names = this.findPredicateTableNames();
        for (String tableName : names) {
            TripleTable table = this.factory.createTripleTable(this.conn, tableName);
            table.setIdSequence(this.ids);
            if (tableName.equalsIgnoreCase("TRIPLES")) {
                table.setPredColumnPresent(true);
            }
            if (this.indexingTriples && !table.isIndexed()) {
                table.createIndex();
            }
            table.reload();
            tables.put(this.key(tableName), table);
        }
        return tables;
    }

    protected Set<String> findTablesWithColumn(String column) throws SQLException {
        Set<String> tables = this.findTablesWithExactColumn(column.toUpperCase());
        if (tables.isEmpty()) {
            return this.findTablesWithExactColumn(column.toLowerCase());
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> findTablesWithExactColumn(String column) throws SQLException {
        HashSet<String> tables = new HashSet<String>();
        DatabaseMetaData metaData = this.conn.getMetaData();
        String c = null;
        String s = null;
        String n = null;
        ResultSet rs = metaData.getColumns(c, s, n, column);
        try {
            while (rs.next()) {
                String tableName = rs.getString(3);
                tables.add(tableName);
            }
            HashSet<String> hashSet = tables;
            return hashSet;
        }
        finally {
            rs.close();
        }
    }

    protected synchronized String getExpungeCondition() throws SQLException {
        StringBuilder sb = new StringBuilder(1024);
        for (Map.Entry<Number, TripleTable> e : this.tables.entrySet()) {
            sb.append("\nAND id <> ").append(e.getKey());
            if (e.getValue().isEmpty()) continue;
            sb.append(" AND NOT EXISTS (SELECT * FROM ");
            sb.append(e.getValue().getNameWhenReady());
            sb.append(" WHERE ctx = id OR subj = id OR obj = id");
            if (e.getValue().isPredColumnPresent()) {
                sb.append(" OR pred = id");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    protected String getNewTableName(Number pred) throws SQLException {
        String prefix = this.getTableNamePrefix(pred);
        String tableName = prefix + "_" + pred;
        return tableName;
    }

    protected Number key(String tn) {
        if (tn.equalsIgnoreCase("TRIPLES")) {
            return this.OTHER_PRED;
        }
        Number id = this.ids.idOf(Long.valueOf(tn.substring(tn.lastIndexOf(95) + 1)));
        assert (id.longValue() != 0L);
        return id;
    }

    protected String getTableNamePrefix(Number pred) throws SQLException {
        String uri = this.predicates.getPredicateUri(pred);
        if (uri == null) {
            return "TRIPLES";
        }
        Matcher m = this.tablePrefix.matcher(uri);
        if (!m.find()) {
            return "TRIPLES";
        }
        String localName = m.group(1).replaceAll("^[^a-zA-Z]*", "");
        if (localName.length() == 0) {
            return "TRIPLES";
        }
        if (localName.length() > 16) {
            return localName.substring(0, 16);
        }
        return localName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initThread() throws SQLException, InterruptedException {
        this.logger.debug("Starting helper thread {}", (Object)this.initThread.getName());
        while (!this.closed) {
            TripleTable table = null;
            LinkedList<TripleTable> linkedList = this.queue;
            synchronized (linkedList) {
                if (this.queue.isEmpty()) {
                    this.queue.wait();
                }
                if (!this.queue.isEmpty()) {
                    table = this.queue.removeFirst();
                }
            }
            if (table == null) continue;
            table.initTable();
            Object var1_1 = null;
        }
        this.logger.debug("Closing helper thread {}", (Object)this.initThread.getName());
    }

    private Set<String> findPredicateTableNames() throws SQLException {
        Set<String> names = this.findAllTables();
        names.retainAll(this.findTablesWithColumn("ctx"));
        names.retainAll(this.findTablesWithColumn("subj"));
        names.retainAll(this.findTablesWithColumn("obj"));
        return names;
    }

    private void initTable(TripleTable table) throws SQLException {
        if (this.exc != null) {
            this.throwException();
        }
        table.setIndexed(this.indexingTriples);
        table.initTable();
    }

    private void throwException() throws SQLException {
        if (this.exc instanceof SQLException) {
            SQLException e = (SQLException)this.exc;
            this.exc = null;
            throw e;
        }
        if (this.exc instanceof RuntimeException) {
            RuntimeException e = (RuntimeException)this.exc;
            this.exc = null;
            throw e;
        }
    }
}

