/*
 * Decompiled with CFR 0.152.
 */
package slib.utils.i;

import java.util.HashMap;
import java.util.Map;
import slib.utils.ex.SLIB_Ex_Critic;

public class Conf {
    Map<String, Object> params;

    public String getParamAsString(String p) {
        if (this.params == null) {
            return null;
        }
        return (String)this.params.get(p);
    }

    public Object getParam(String p) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(p);
    }

    public double getParamAsDouble(String p) throws SLIB_Ex_Critic {
        double val;
        String pval = this.getParam(p).toString();
        try {
            val = Double.parseDouble(pval);
        }
        catch (Exception e) {
            throw new SLIB_Ex_Critic("Error converting " + p + " parameter to numeric value");
        }
        return val;
    }

    public boolean containsParam(String p) {
        return this.getParam(p) != null;
    }

    public Conf addParam(String p, Object v) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(p, v);
        return this;
    }

    public void removeParam(String p) {
        if (this.containsParam(p)) {
            this.params.remove(p);
        }
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(HashMap<String, Object> params) {
        this.params = params;
    }

    public boolean containsParams() {
        return this.params != null && this.params.isEmpty();
    }

    public String toString() {
        String out = "";
        if (this.params != null) {
            for (String s : this.params.keySet()) {
                out = out + s + "\t" + this.params.get(s).toString() + "\n";
            }
        } else {
            out = "empty";
        }
        return out;
    }
}

