\name{PWMEnrich.Mmusculus.background-package}
\alias{PWMEnrich.Mmusculus.background-package}
\alias{PWMEnrich.Mmusculus.background}
\alias{MotifDb.Mmus.PFM}
\alias{MotifDb.Mmus}
\alias{PWMLogn.mm9.MotifDb.Mmus}
\alias{PWMCutoff4.mm9.MotifDb.Mmus}
\alias{PWMCutoff5.mm9.MotifDb.Mmus}
\alias{PWMGEV.mm9.MotifDb.Mmus}
\alias{PWMPvalueCutoff1e2.mm9.MotifDb.Mmus}
\alias{PWMPvalueCutoff1e3.mm9.MotifDb.Mmus}
\alias{PWMPvalueCutoff1e4.mm9.MotifDb.Mmus}
\alias{mm9.upstream2000}
\docType{package}

\title{
  PWMEnrich.Mmusculus.background package overview
}

\description{
    This package provides a set of pre-compiled genomic background files for the \code{PWMEnrich} package and M. musculus (mouse). The backgrounds
  were pre-compiled using unique 2kb promoters in mouse. 
  
  \itemize{
  	\item \code{MotifDb.Mmus.PFM} - a list of position frequency matrices (PFMs) from \code{MotifDb}
  	
  	\item \code{MotifDb.Mmus} - the corresponding PWMs generated by using the background frequencies of A,C,G,T in a set of 2kb mouse (mm9) promoters. 
  	
  	\item \code{PWMLogn.mm9.MotifDb.Mmus} - pre-compiled threshold-free lognormal background for MotifDb mouse PWMs. 
  	The lognormal distribution is fitted to 500bp chunks of 2kb mouse (mm9) promoters. 
  	
  	\item \code{PWMCutoff4.mm9.MotifDb.Mmus}, \code{PWMCutoff5.mm9.MotifDb.Mmus} - pre-compiled Z-score background with cutoff of 4 and 5 (base e) for 
  	MotifDb mouse PWMs. The number of hits is counted in 2kb mouse (mm9) promoters.  
  	
  	\item \code{PWMPvalueCutoff1e2.mm9.MotifDb.Mmus}, \code{PPWMPvalueCutoff1e3.mm9.MotifDb.Mmus},
  	\code{PPWMPvalueCutoff1e4.mm9.MotifDb.Mmus} - pre-compiled Z-score background with P-value cutoff of 0.01, 0.001, and 0.0001 for 
  	MotifDb mouse PWMs. The number of hits with smaller P-value than cutoff is counted in 2kb mouse	(mm9) promoters. 
  }
}

\usage{
	data(MotifDb.Mmus.PFM)
	data(MotifDb.Mmus)
	data(PWMLogn.mm9.MotifDb.Mmus)
	data(PWMCutoff4.mm9.MotifDb.Mmus)
	data(PWMCutoff5.mm9.MotifDb.Mmus)
	data(PWMPvalueCutoff1e2.mm9.MotifDb.Mmus)
	data(PWMPvalueCutoff1e3.mm9.MotifDb.Mmus)
	data(PWMPvalueCutoff1e4.mm9.MotifDb.Mmus)
}

\details{
	All of these objects were created with the appropriate functions available in the \code{PWMEnrich} package (see Section 'See also'). We
	recommend using these functions to generate backgrounds for a custom set of background sequences and/or DNA motifs. 
	
	This package also contains the 2kb upstream sequences for mouse genes (\code{mm9.upstream2000}) which were removed from the BSgenome.Mmusculus.UCSC.mm9 package
	starting from Bioconductor version 3.0. 
}

\examples{
	data(PWMLogn.mm9.MotifDb.Mmus)
	
	res = motifEnrichment(DNAString("TGCATCAAGTGTGTAGTGCAAGTGAGTGATGAATGC"), 
	  PWMLogn.mm9.MotifDb.Mmus)
	
	groupReport(res)[1:10]
}

\author{
  Robert Stojnic\cr
  Cambridge Systems Biology Centre\cr
  University of Cambridge, UK

  Maintainer: Robert Stojnic \email{robert.stojnic@gmail.com}
}

\seealso{
	 \code{\link{makeBackground}}, \code{\link{makePWMLognBackground}}, \code{\link{makePWMCutoffBackground}}, \code{\link{makePWMEmpiricalBackground}}.
}

\keyword{ package }
