% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LohoffGastrulationData.R
\name{LohoffGastrulationData}
\alias{LohoffGastrulationData}
\title{seqFISH mouse gastrulation dataset}
\usage{
LohoffGastrulationData(
  dataset = datasets,
  file_path = ".",
  force = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{dataset}{Which dataset to use, must be one of "rep1", "rep2", and "rep3".}

\item{file_path}{Path to save downloaded files for the \code{*Output}
functions which don't return an SFE object.}

\item{force}{Logical, whether to force redownload if the files are already
present. Defaults to \code{FALSE}.}

\item{verbose}{Whether to display progress of download.}
}
\value{
A \code{SpatialFeatureExperiment} object.
}
\description{
This dataset was downloaded from the
\href{https://marionilab.cruk.cam.ac.uk/SpatialMouseAtlas/}{companion website}
titled, Integration of spatial and single-cell transcriptomic data elucidates
mouse organogenesis \href{https://doi.org/10.1038/s41587-021-01006-2}{Lohoff et al}.
There are three biological replicates available in this dataset, each
representing a different embryo. For each dataset, the raw gene counts,
metadata, and cell segmentation in one z-plane are provided in the SFE object.
Segmentation data were not provided for provided for all cells in the count
matrix for embryos 1 and 2. In these cases, the segmentation data are
represented by empty polygons.
}
\details{
While the authors provided the spot location for each mRNA molecule, these
are not included in the SFE objects.
}
