## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  warning = FALSE,
  message = FALSE,
  comment = "#>"
)

## ----eval=FALSE---------------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("SubcellularSpatialData")

## ----load-packages, message=FALSE---------------------------------------------
library(SubcellularSpatialData)
library(ExperimentHub)

## ----get-SubcellularSpatialData-----------------------------------------------
eh = ExperimentHub()
query(eh, "SubcellularSpatialData")

## ----download-SubcellularSpatialData, eval=FALSE------------------------------
# eh[["EH8230"]]

## -----------------------------------------------------------------------------
# load internal sample data
data(tx_small)
# view data
head(tx_small)

## -----------------------------------------------------------------------------
library(ggplot2)
tx_small |>
  ggplot(aes(x, y, colour = region)) +
  geom_point(pch = ".") +
  scale_colour_brewer(palette = "Set2", guide = guide_legend(override.aes = list(shape = 15, size = 5))) +
  facet_wrap(~sample_id, ncol = 2, scales = "free") +
  theme_minimal() +
  theme(legend.position = "bottom")

## -----------------------------------------------------------------------------
library(SpatialExperiment)

# summarising counts per cell
tx2spe(tx_small, bin = "cell")

# summarising counts per square bin
tx2spe(tx_small, bin = "square", nbins = 30)

# summarising counts per hex bin
tx2spe(tx_small, bin = "hex", nbins = 30)

# summarising counts per region
tx2spe(tx_small, bin = "region")

## -----------------------------------------------------------------------------
sessionInfo()

