% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPPA.R
\docType{data}
\name{RPPA}
\alias{RPPA}
\alias{RPPA_19Q3}
\alias{RPPA_19Q2}
\alias{RPPA_19Q1}
\alias{depmap_RPPA}
\title{RPPA_19Q3}
\format{
A data frame with 192386 rows and 4 variables:
\describe{
    \item{depmap_id}{cancer cell line foreign key (i.e. "ACH-000001")}
    \item{cell_line}{CCLE name of cancer cell line (i.e. "NIHOVCAR3_OVARY")}
    \item{antibody}{Name of antibody targeting protein (i.e. "14-3-3_beta")}
    \item{expression}{Observed expression via RPPA of protein coding genes}
}
}
\source{
DepMap, Broad Institute: https://depmap.org/portal/download/
}
\usage{
RPPA
}
\description{
The `RPPA` dataset contains the 19Q3 CCLE Reverse Phase Protein Array (RPPA)
cellular model expression data. This dataset includes data from 214 genes,
899 cancer cell lines, 28 primary diseases and 28 lineages. The columns of
`RPPA` are: `depmap_id`, a foreign key corresponding to the cancer cell
lineage, `cell_line` which contains the common CCLE name of the cancer cell
lines, `gene` which contains the knockdown gene expression, `antibody`
containing the name of knocked down gene and `expression` containing
numerical protein expression data. This dataset can be loaded into R
environment with the `depmap_RPPA` function.
}
\details{
This data represents the `CCLE_RPPA_20181003.csv` file taken from
the 19Q3 [Broad Institute](https://depmap.org/portal/download/) cancer
depenedency study. The derived dataset found in the `depmap` package features
the addition of a foreign key `depmap_id` found in the first column of this
dataset, which was added from the `metadata` dataset. This dataset has been
converted to a long format tibble. Variables names from the original dataset
were converted to lower case, put in snake case, and abbreviated where
feasible.
}
\section{Change log}{


- 19Q1: Initial dataset consisted of a data frame with 192386 rows and 4
variables representing 214 genes, 899 cancer cell lines, 28 primary diseases
and 28 lineages.

- 19Q2: no change

- 19Q3: no change, no further releases are scheduled at this time.

- 19Q4: no change, no further releases are scheduled at this time.

- 20Q1: no change, no further releases are scheduled at this time.

- 20Q2: no change, no further releases are scheduled at this time.

- 20Q3: no change, no further releases are scheduled at this time.

- 20Q4: no change, no further releases are scheduled at this time.

- 21Q1: no change, no further releases are scheduled at this time.

- 21Q2: no change, no further releases are scheduled at this time.

- 21Q3: no change, no further releases are scheduled at this time.

- 21Q4: no change, no further releases are scheduled at this time.

- 22Q1: no change, no further releases are scheduled at this time.

- 22Q2: no change, no further releases are scheduled at this time.
}

\examples{
\dontrun{
depmap_RPPA()
}

}
\references{
Tsherniak, A., Vazquez, F., Montgomery, P. G., Weir, B. A.,
Kryukov, G., Cowley, G. S., ... & Meyers, R. M. (2017). Defining a cancer
dependency map. Cell, 170(3), 564-576.

Mahmoud Ghandi, Franklin W. Huang, Judit Jané-Valbuena, Gregory V. Kryukov,
... Todd R. Golub, Levi A. Garraway & William R. Sellers. 2019. Next-
generation characterization of the Cancer Cell Line Encyclopedia. Nature 569,
503–508 (2019).

Haoxin Li, Shaoyang Ning, Mahmoud Ghandi, Gregory V. Kryukov, Shuba Gopal,
... Levi A. Garraway & William R. Sellers. The landscape of cancer cell line
metabolism. Nature Medicine 25, 850-860 (2019).
}
\keyword{datasets}
