\name{flowPloidyData}

\alias{flowPloidyData}
\alias{flowPloidyFiles}
\alias{fpBad}
\alias{fpVac}

\docType{data}

\title{Example flow cytometry datasets from analysis of ploidy in
  plants.}

\description{
  A list of LMD files from analyses of the plant leaf tissue samples,
  co-chopped with standards with known GC (e.g., tomato, soybean etc.).
}

\usage{

flowPloidyFiles()

fpBad()

fpVac()

}

\format{
  The function \code{flowPloidyFiles} returns a vector of filenames
  corresponding to the LMD files provided by this package. Individual
  elements of this vector (e.g., \code{flowPloidyFiles()[1]} can be passed
  to functions that load a single FCS file, such as
  \code{flowCore::read.FCS}. The entire vector can be passed to
  functions that load multiple files, such as
  \code{flowPloidy::histBatch}.

  Each element is named with the filename (without the path), so that
  you can select an individual filename either by numeric index
  (i.e., \code{flowPloidyFiles()[7]}) or by name
  (\code{flowPloidyFiles()["248+S.LMD"]}). The names aren't meaningful to
  you, of course! I added them to provide a more robust way to select an
  individual file, as the order of files may change in package updates.

  The individual files named in \code{flowPloidyFiles} are LMD files
  generated by a Beckman-Coulter Gallios flow cytometer. They represent
  a variety of samples, and some of them are low quality. They are not
  ideal data sets, but rather represent a range of data quality for
  assessing the performance of \code{flowPloidy}.

  \code{fpBad()} and \code{fpVac()} each return the path to a single LMD
  file. These are particularly poor quality files that are used in some
  of the unit tests for \code{flowPloidy}. They're probably not useful
  to regular users.
}

\value{
  A named character vector of file names, including their full path in
  the local file system.
}

\examples{
flowPloidyFiles()   ## a character vector of file names

## Read in the first file:
library(flowCore)
fcs <- read.FCS(flowPloidyFiles()[1], dataset = 1,
                          alter.names = TRUE)
}

\keyword{datasets}
