\docType{data}
\name{gnw1565.data}
\alias{gnw1565.data}
\title{Simulated Gene Expression Data}
\description{
    Dataset containing 1565 samples and 1565 genes generated by the publicly
    available GNW generator using an ecoli source network with no added noise.
}
\usage{data(gnw1565.data)}
\format{
    \code{gnw1565.data} is a data frame containing 1565 rows and 1565 columns. 
    Each row contains a simulated microarray experiment and each column contains 
    a gene. The dataset was generated with GNW generator which relies on ODEs 
    for modeling gene regulation.
}
\source{
    GNW v3.1  with source network : Ecoli
}
\references{
    Schaffter, Thomas, Daniel Marbach, and Dario Floreano. "GeneNetWeaver: 
    in silico benchmark generation and performance profiling of network 
    inference methods." Bioinformatics 27.16 (2011): 2263-2270.
}
\value{
    \code{data.frame} containg the data.
}
\seealso{
    \code{\link{gnw1565.net}}, \code{\link{gnw2000.data}}, 
    \code{\link{rogers1000.data}}, \code{\link{syntren300.data}},
    \code{\link{syntren1000.data}}
}
\examples{
    data(gnw1565.data)
    # Print size
    print(dim(gnw1565.data))
}
\keyword{datasets}
