% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessMSigDB.R
\name{getIMEX}
\alias{getIMEX}
\title{Retrieve IMEx PPI hosted on the hub}
\usage{
getIMEX(org = c("hs", "mm"), inferred = FALSE, version = getIMEXVersions())
}
\arguments{
\item{org}{a character, representing the organism whose PPI database needs to
be retrieved ("hs" for human and "mm" for mouse).}

\item{inferred}{a logical, indicating whether inference from other organisms
should be included in the PPI.}

\item{version}{a character, stating the version of IMEX to be retrieved. See
\code{getMsigdbVersions()}.}
}
\value{
a data.frame, containing the IMEx PPI.
}
\description{
Download International Molecular Exchange (IMEx) protein-protein interaction
(PPI) hosted on the ExperimentHub or retrieve pre-downloaded version from
cache. This package currently hosts versions for human and mouse with both
symbol and Entrez identifiers.
}
\examples{
imex = getIMEX("hs")

}
