### =========================================================================
### multiWGCNAdata metadata
### -------------------------------------------------------------------------
###

meta <- data.frame(
  Title = c(paste0("Regional expression profiles of autistic brain"),
            paste0("Metadata for regional expression profiles of autistic brain"),
            paste0("Autisic brain SummarizedExperiment"),
            paste0("Regional astrocyte expression profiles in experimental autoimmune encephalomyelitis"),
            paste0("Metadata for regional astrocyte expression profiles in experimental autoimmune encephalomyelitis"),
            paste0("Astrocyte weighted gene coexpression networks"),
            paste0("Astrocyte Ribotag SummarizedExperiment"),
            paste0("Timecourse expression profiles of tau pathology in entorhinal cortex"),
            paste0("Metadata for timecourse expression profiles of tau pathology in entorhinal cortex"),
            paste0("Tau weighted gene coexpression networks"),
            paste0("Tau pathology SummarizedExperiment")),
  Description = c(paste0("The regional autism dataset from Voineagu et al. 2011, extracted from the Gene Expression Omnibus (accession number GSE28521)."),
                  paste0("The metadata for the regional autism dataset (Voineagu et al. 2011)."),
                  paste0("SummarizedExperiment object for the regional autism dataset (Voineagu et al. 2011)."),
                  paste0("The astrocyte dataset from Itoh et al. PNAS. 2018, extracted from the supplementary materials."),
                  paste0("The metadata for the astrocyte Ribotag dataset (Itoh et al. PNAS. 2018)."),
                  paste0("The astrocyte networks from Tommasini and Fogel, BMC Bioinformatics, 2023. derived from the astrocyte Ribotag data from Itoh et al. PNAS. 2018."),
                  paste0("SummarizedExperiment object for the astrocyte Ribotag dataset (Itoh et al. PNAS. 2018)."),
                  paste0("The tau dataset from Castanho et al. Cell Rep. 2020, extracted from GEO (GSE125957) processed data file."),
                  paste0("The metadata for the tau timecourse dataset (Castanho et al. Cell Rep. 2020)."),
                  paste0("The tau networks from Tommasini and Fogel, BMC Bioinformatics, 2023. derived from the tau timecourse data from Castanho et al. Cell Rep. 2020."), 
                  paste0("SummarizedExperiment object for the tau timecourse dataset (Castanho et al. Cell Rep. 2020).")),
  BiocVersion = "3.18",
  Genome = c(rep(NA, 3),
             rep("mm10", 8)),
  SourceType = rep("TXT", 11),
  SourceUrl = c(rep("https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE28521", 3),
                rep("https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE100329", 4),
                rep("https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE125957", 4)),
  SourceVersion = c(rep("Mar 20 2017", 3), 
                    rep("May 15 2019", 4), 
                    rep("Feb 24 2020", 4)),
  Species = c(rep("Homo sapiens", 3),
              rep("Mus musculus", 8)),
  TaxonomyId = c(rep(9606, 3),
                 rep(10090, 8)),
  Coordinate_1_based = NA,
  DataProvider = "GEO",
  Maintainer = "Dario Tommasini <dtommasini0@gmail.com>",
  RDataClass = c(rep("list", 2), "SummarizedExperiment", 
                 rep("list", 3), "SummarizedExperiment", 
                 rep("list", 3), "SummarizedExperiment"), 
  DispatchClass = c(rep("Rda", 11)),
  RDataPath = paste0("multiWGCNAdata/",
                       c("autism_data.rda",
                         "autism_metadata.rda",
                         "autism_se.rda",
                         "astrocyte_data.rda",
                         "astrocyte_metadata.rda",
                         "astrocyte_networks.rda",
                         "astrocyte_se.rda",
                         "tau_data.rda",
                         "tau_metadata.rda",
                         "tau_networks.rda",
                         "tau_se.rda")),
  Tags = ""
)

write.csv(meta, file="inst/extdata/metadata.csv", row.names=FALSE)
