% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{GM12878_ChIP_H3K27ac_signal}
\alias{GM12878_ChIP_H3K27ac_signal}
\title{plotgardener example GM12878 H3K27ac ChIP signal data}
\format{
a dataframe in BED format with a "score" column
\describe{
\item{chrom}{The name of the chromosome on which the genome
feature exists.}
\item{start}{The starting position of the feature in the chromosome.}
\item{end}{The ending position of the feature in the chromosome.}
\item{score}{Score value of read depth.}
}
}
\source{
Data with reference epigenome identifier \strong{E116}
was downloaded from the
NIH Roadmap Epigenomics Project \url{http://www.roadmapepigenomics.org/}.
}
\usage{
data("GM12878_ChIP_H3K27ac_signal")
}
\description{
A dataset listing read depths across the genome resulting from
H3K27ac ChIP-seq in the GM12878 cell line. Genomic coordinates
fall within the region chr21:28000000-30300000 according to the
hg19 genome build.
}
\references{
Roadmap Epigenomics Consortium.,
Integrative analysis coordination., Kundaje, A. et al.
Integrative analysis of 111 reference human epigenomes.
Nature 518, 317–330 (2015). https://doi.org/10.1038/nature14248
}
\keyword{datasets}
