% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ERCCSpikeInConcentrations.R
\name{ERCCSpikeInConcentrations}
\alias{ERCCSpikeInConcentrations}
\title{Obtain ERCC concentrations}
\usage{
ERCCSpikeInConcentrations(
  volume = NULL,
  dilution = NULL,
  mix = c("1", "2"),
  legacy = FALSE
)
}
\arguments{
\item{volume}{Numeric scalar specifying the added volume (in nanoliters) of ERCC spike-in mixture.
Only used if \code{dilution} is specified.}

\item{dilution}{Numeric scalar specifying the dilution factor used for the added volume of the spike-in mixture.
Only used if \code{volume} is specified.}

\item{mix}{String specifying whether to compute the number of molecules for mix 1 or 2.
Only used if both \code{dilution} and \code{volume} are specified.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[S4Vectors]{DataFrame} object with one row per ERCC spike-in transcript.
This contains information such as the spike-in concentration in each mix.
}
\description{
Obtain ERCC spike-in concentrations from the Thermo Fisher Scientific website.
}
\details{
If \code{volume} and \code{dilution} are specified,
an additional column is added to the output specifying the number of molecules of spike-in transcipt for the specified mix.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/ercc-concentrations}.
}
\examples{
df <- ERCCSpikeInConcentrations()

}
\author{
Alan O'Callaghan
}
