% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specht2019v3.R
\docType{data}
\name{specht2019v3}
\alias{specht2019v3}
\title{Specht et al. 2019 - SCoPE2 (biorRxiv): macrophages vs monocytes
(version 3)}
\format{
A \link{QFeatures} object with 179 assays, each assay being a
\link{SingleCellExperiment} object:
\itemize{
\item Assay 1-63: PSM data for SCoPE2 sets acquired with a TMT-11plex
protocol, hence those assays contain 11 columns. Columns
hold quantitative information from single-cell channels, carrier
channels, reference channels, empty (blank) channels and unused
channels.
\item Assay 64-177: PSM data for SCoPE2 sets acquired with a
TMT-16plex protocol, hence those assays contain 16 columns.
Columns hold quantitative information from single-cell channels,
carrier channels, reference channels, empty (blank) channels and
unused channels.
\item \code{peptides}: peptide data containing quantitative data for 9208
peptides and 1018 single-cells.
\item \code{proteins}: protein data containing quantitative data for 2772
proteins and 1018 single-cells.
}

The \code{colData(specht2019v2())} contains cell type annotation and
batch annotation that are common to all assays. The description of
the \code{rowData} fields for the PSM data can be found in the
\href{http://www.coxdocs.org/doku.php?id=maxquant:table:evidencetable}{\code{MaxQuant} documentation}.
}
\source{
The data were downloaded from the
\href{https://scope2.slavovlab.net/docs/data}{Slavov Lab} website via a
shared Google Drive
\href{https://drive.google.com/drive/folders/1VzBfmNxziRYqayx3SP-cOe2gu129Obgx}{folder}.
The raw data and the quantification data can also be found in the
massIVE repository \code{MSV000083945}:
ftp://massive.ucsd.edu/MSV000083945.
}
\usage{
specht2019v3
}
\description{
Single cell proteomics data acquired by the Slavov Lab. This is
the version 3 of the data released in October 2020. It contains
quantitative information of macrophages and monocytes at PSM,
peptide and protein level.
}
\note{
Since version 2, a serious bug in the data were corrected
for TMT channels 12 to 16. Many more cells are therefore contained
in the data. Version 2 is maintained for backward compatibility.
Although the final version of the article was published in 2021,
we have kept \code{specht2019v3} as the data set name for consistency
with the previous data version \code{specht2019v2}.
}
\section{Acquisition protocol}{


The data were acquired using the following setup. More information
can be found in the source article (see \code{References}).
\itemize{
\item \strong{Cell isolation}: flow cytometry (BD FACSAria I).
\item \strong{Sample preparation} performed using the SCoPE2 protocol. mPOP
cell lysis + trypsin digestion + TMT-11plex or 16plex labeling
and pooling.
\item \strong{Separation}: online nLC (DionexUltiMate 3000 UHPLC with a
25cm x 75um IonOpticksAurora Series UHPLC column; 200nL/min).
\item \strong{Ionization}: ESI (2,200V).
\item \strong{Mass spectrometry}: Thermo Scientific Q-Exactive (MS1
resolution = 70,000; MS2 accumulation time = 300ms; MS2
resolution = 70,000).
\item \strong{Data analysis}: DART-ID + MaxQuant (1.6.2.3).
}
}

\section{Data collection}{


The PSM data were collected from a shared Google Drive folder that
is accessible from the SlavovLab website (see \code{Source} section).
The folder contains the following files of interest:
\itemize{
\item \code{ev_updated_v2.txt}: the MaxQuant/DART-ID output file
\item \verb{annotation_fp60-97.csv}: sample annotation
\item \verb{batch_fp60-97.csv}: batch annotation
}

We combined the sample annotation and the batch annotation in
a single table. We also formatted the quantification table so that
columns match with those of the annotation and filter only for
single-cell runs. Both table are then combined in a single
\link{QFeatures} object using the \code{\link[scp:readSCP]{scp::readSCP()}} function.

The peptide data were taken from the Slavov lab directly
(\code{Peptides-raw.csv}). It is provided as a spreadsheet. The data
were formatted to a \link{SingleCellExperiment} object and the sample
metadata were matched to the column names (mapping is retrieved
after running the SCoPE2 R script) and stored in the \code{colData}.
The object is then added to the \link{QFeatures} object (containing the
PSM assays) and the rows of the peptide data are linked to the
rows of the PSM data based on the peptide sequence information
through an \code{AssayLink} object.

The protein data (\code{Proteins-processed.csv}) is formatted similarly
to the peptide data, and the rows of the proteins were mapped onto
the rows of the peptide data based on the protein sequence
information.
}

\examples{
\donttest{
specht2019v3()
}

}
\references{
Specht, Harrison, Edward Emmott, Aleksandra A.
Petelski, R. Gray Huffman, David H. Perlman, Marco Serra, Peter
Kharchenko, Antonius Koller, and Nikolai Slavov. 2021.
"Single-Cell Proteomic and Transcriptomic Analysis of Macrophage
Heterogeneity Using SCoPE2." Genome Biology 22 (1): 50.
(\href{http://dx.doi.org/10.1186/s13059-021-02267-5}{link to article}).
}
\keyword{datasets}
