% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/williams2020_lfq.R
\docType{data}
\name{williams2020_lfq}
\alias{williams2020_lfq}
\title{Williams et al. 2020 (Anal. Chem.): MCF10A cell line}
\format{
A \link{QFeatures} object with 9 assays, each assay being a
\link{SingleCellExperiment} object:
\itemize{
\item \verb{peptides_[30 or 60]min_[intensity or LFQ]}: 3 assays
containing peptide intensities or LFQ normalized
quantifications (see \code{References}) for either a 30min or a 60 min
gradient.
\item \verb{proteins_[30 or 60]min_[intensity or iBAQ or LFQ]}: 6 assays
containing protein intensities, iBAQ normalized or LFQ normalized
quantifications (see \code{References}) for either a 30min or a 60 min
gradient.
}

Sample annotation is stored in \code{colData(williams2020_lfq())}.
}
\source{
The PSM and protein data can be downloaded from the MASSIVE
repository MSV000085230.
}
\usage{
williams2020_lfq
}
\description{
Single-cell label free proteomics data from a MCF10A cell line
culture. The data were acquired using a label-free quantification
protocole based on the nanoPOTS technology. The objective was to
test 2 elution gradients for single-cell applications and to
demonstrate successful use of the new nanoPOTS autosampler
presented in the article. The samples contain either no cells,
single cells, 3 cells, 10 cells  50 cells.
}
\section{Acquisition protocol}{


The data were acquired using the following setup. More information
can be found in the source article (see \code{References}).
\itemize{
\item \strong{Sample isolation}: cultured MCF10A cells were isolated using
flow-cytometry based cell sorting and deposit on nanoPOTS
microwells
\item \strong{Sample preparation}: cells are lysed using using a DDM+DTT
lysis buffer. Alkylation was then performed using an IAA solution.
Proteins are digested with Lys-C and trypsin followed by
acidification with FA. Sample droplets are then dried until
LC-MS/MS analysis.
\item \strong{Liquid chromatography}: peptides are loaded using the new
autosampler described in the paper. Samples are loaded using a
a homemade miniature syringe pump. The samples are then desalted
and concentrated through a SPE column (4cm x 100µm i.d. packed
with 5µm C18) with microflow LC pump. The peptides are then eluted
from a long LC column (60cm x 50 µm i.d. packed with 3µm C18)
coupled to a nanoflox LC pump at 150nL/mL with either a 30 min
or a 60 min gradient.
\item \strong{Mass spectrometry}: MS/MS was performed on an Orbitrap Fusion
Lumos Tribrid MS coupled to a 2kV ESI. MS1 setup: Orbitrap
analyzer at resolution 120.000, AGC target of 1E6, accumulation
of 246ms. MS2 setup: ion trap with CID at resolution 60.000, AGC
target of 2E4, accumulation of 120ms (50 cells) or 250ms (0-10
cells).
\item \strong{Raw data processing}: preprocessing using Maxquant v1.6.2.10
that use Andromeda search engine (with UniProtKB 2016-21-29),
MBR and LFQ normalization were enabled.
}
}

\section{Data collection}{


All data were collected from the MASSIVE repository (accession ID:
MSV000085230).

The peptide and protein data were extracted from the \verb{Peptides_[...].txt}
or \verb{ProteinGroups[...].txt} files, respectively, in the
\verb{MCF10A_LC_[30 or 60]minutes} folders.

The tables were duplicated so that peptide intensisities, peptide
LFQ, protein intensities, protein LFQ and protein intensities are
contained in separate tables. Tables are then converted to
\link{SingleCellExperiment} objects. Sample annotations were infered
from the sample names and from the paper. All data is combined in
a \link{QFeatures} object. \link{AssayLinks} were stored between peptide
assays and their corresponding proteins assays based on the
leading razor protein (hence only unique peptides are linked to
proteins).

The script to reproduce the \code{QFeatures} object is available at
\code{system.file("scripts", "make-data_williams2020_lfq.R", package = "scpdata")}
}

\section{Suggestion}{


See \code{QFeatures::joinAssays} if you want to join the 30min and
60min assays in a single assay for an integrated analysis.
}

\examples{
\donttest{
williams2020_lfq()
}

}
\references{
\strong{Source article}: Williams, Sarah M., Andrey V. Liyu, Chia-Feng
Tsai, Ronald J. Moore, Daniel J. Orton, William B. Chrisler,
Matthew J. Gaffrey, et al. 2020. “Automated Coupling of
Nanodroplet Sample Preparation with Liquid Chromatography-Mass
Spectrometry for High-Throughput Single-Cell Proteomics.”
Analytical Chemistry 92 (15): 10588–96.
(\href{http://dx.doi.org/10.1021/acs.analchem.0c01551}{link to article}).

\strong{LFQ normalization}: Cox, Jürgen, Marco Y. Hein, Christian A. Luber,
Igor Paron, Nagarjuna Nagaraj, and Matthias Mann. 2014. “Accurate
Proteome-Wide Label-Free Quantification by Delayed Normalization
and Maximal Peptide Ratio Extraction, Termed MaxLFQ.” Molecular
& Cellular Proteomics: MCP 13 (9): 2513–26.
(\href{http://dx.doi.org/10.1074/mcp.M113.031591}{link to article}).

\strong{iBAQ normalization}: Schwanhäusser, Björn, Dorothea Busse, Na
Li, Gunnar Dittmar, Johannes Schuchhardt, Jana Wolf, Wei Chen, and
Matthias Selbach. 2011. “Global Quantification of Mammalian Gene
Expression Control.” Nature 473 (7347): 337–42.
(\href{http://dx.doi.org/10.1038/nature10098}{link to article}).
}
\keyword{datasets}
