% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genome.R
\name{sesameData_getTxnGRanges}
\alias{sesameData_getTxnGRanges}
\title{convert GRangesList to transcript GRanges}
\usage{
sesameData_getTxnGRanges(genome = NULL, grl = NULL, merge2gene = FALSE)
}
\arguments{
\item{genome}{hg38, mm10, ...}

\item{grl}{GRangesList object}

\item{merge2gene}{merge transcript to genes}
}
\value{
a GRanges object
}
\description{
convert GRangesList to transcript GRanges
}
\examples{

## all mm10 transcripts
txns <- sesameData_getTxnGRanges("mm10")

## verified protein-coding transcripts
txns[(txns$transcript_type == "protein_coding" & txns$level <= 2)]

## merged to genes
sesameData_getTxnGRanges("mm10", merge2gene = TRUE)

}
