% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_modeling_results.R
\name{check_modeling_results}
\alias{check_modeling_results}
\title{Check input modeling_results}
\usage{
check_modeling_results(modeling_results)
}
\arguments{
\item{modeling_results}{Defaults to the output of
\code{fetch_data(type = 'modeling_results')}. This is a list of tables with the
columns \verb{f_stat_*} or \verb{t_stat_*} as well as \verb{p_value_*} and \verb{fdr_*} plus
\code{ensembl}. The column name is used to extract the statistic results, the
p-values, and the FDR adjusted p-values. Then the \code{ensembl} column is used
for matching in some cases. See \code{\link[=fetch_data]{fetch_data()}} for more details. Typically
this is the set of reference statistics used in \code{layer_stat_cor()}.}
}
\value{
The input object if all checks are passed.
}
\description{
This function checks that the \code{modeling_results} object has the appropriate structure.
For more details please check the vignette documentation.
}
\examples{

if (!exists("modeling_results")) {
    modeling_results <- fetch_data(type = "modeling_results")
}

## Check the object
xx <- check_modeling_results(modeling_results)
}
\seealso{
Other Check input functions: 
\code{\link{check_sce}()},
\code{\link{check_sce_layer}()},
\code{\link{check_spe}()}
}
\concept{Check input functions}
