% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_stat_cor_plot.R
\name{layer_stat_cor_plot}
\alias{layer_stat_cor_plot}
\title{Visualize the correlation of layer modeling t-statistics with ComplexHeatmap}
\usage{
layer_stat_cor_plot(
  cor_stats_layer,
  color_max = max(cor_stats_layer),
  color_min = min(cor_stats_layer),
  color_scale = RColorBrewer::brewer.pal(7, "PRGn"),
  query_colors = NULL,
  reference_colors = NULL,
  annotation = NULL,
  ...
)
}
\arguments{
\item{cor_stats_layer}{The output of \code{\link[=layer_stat_cor]{layer_stat_cor()}}.}

\item{color_max}{A \code{numeric(1)} specifying the highest correlation value for
the color scale (should be between 0 and 1).}

\item{color_min}{A \code{numeric(1)} specifying the lowest correlation value for
the color scale (should be between 0 and -1).}

\item{color_scale}{A \code{character} vector with three or more values specifying
the color scale for the fill of the heatmap. The first value is used for
\code{color_min}, the middle for zero, and the last for \code{color_max}. If an even
number of colors are supplied, the last color is dropped to center zero.}

\item{query_colors}{named \code{character} vector of colors, Adds colors to query
row annotations.}

\item{reference_colors}{named \code{character} vector of colors, Adds colors to
reference column annotations.}

\item{annotation}{annotation data.frame output of
\code{\link[=annotate_registered_clusters]{annotate_registered_clusters()}}, adds 'X' for good confidence annotations,
'*' for poor confidence.}

\item{...}{Additional parameters passed to
\code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}} such as \code{cluster_rows}
and \code{cluster_columns}.}
}
\value{
(\link[ComplexHeatmap:Heatmap-class]{Heatmap-class}) plot of t-stat
correlations
}
\description{
This function makes a ComplexHeatmap from the correlation matrix
between a reference and query modeling statistics from \code{\link[=layer_stat_cor]{layer_stat_cor()}}.
For example, between the query statistics from a set of cell cluster/types
derived from scRNA-seq or snRNA-seq data (among other types) and the
reference layer statistics from the Human DLPFC Visium data (when using the
default arguments).
}
\details{
Includes functionality to add color annotations,
(helpful to match to colors in Visium spot plots), and annotations from
\code{\link[=annotate_registered_clusters]{annotate_registered_clusters()}}.
}
\examples{
## Obtain the necessary data
## reference human pilot modeling results
if (!exists("modeling_results")) {
    modeling_results <- fetch_data(type = "modeling_results")
}

## query spatialDLPFC modeling results
query_modeling_results <- fetch_data(
    type = "spatialDLPFC_Visium_modeling_results"
)

## Compute the correlations
cor_stats_layer <- layer_stat_cor(
    stats = query_modeling_results$enrichment,
    modeling_results,
    model_type = "enrichment"
)

## Visualize the correlation matrix

## Default plot with no annotations and defaults for ComplexHeatmap()
layer_stat_cor_plot(cor_stats_layer)

## add Annotation colors
## add libd_layer_colors to reference Human Pilot layers
layer_stat_cor_plot(cor_stats_layer, reference_colors = libd_layer_colors)

## obtain colors for the query clusters
cluster_colors <- get_colors(clusters = rownames(cor_stats_layer))
layer_stat_cor_plot(cor_stats_layer,
    query_colors = cluster_colors,
    reference_colors = libd_layer_colors
)

## Apply additional ComplexHeatmap param
layer_stat_cor_plot(cor_stats_layer,
    cluster_rows = FALSE,
    cluster_columns = FALSE
)

## Add annotation
annotation_df <- annotate_registered_clusters(
    cor_stats_layer,
    confidence_threshold = .55
)
layer_stat_cor_plot(cor_stats_layer, annotation = annotation_df)

## change fill color scale
layer_stat_cor_plot(cor_stats_layer,
    color_scale = RColorBrewer::brewer.pal(2, "PiYG")
)

## All together
layer_stat_cor_plot(
    cor_stats_layer,
    color_scale = RColorBrewer::brewer.pal(5, "PiYG"),
    query_colors = cluster_colors,
    reference_colors = libd_layer_colors,
    annotation = annotation_df,
    cluster_rows = FALSE,
    cluster_columns = FALSE
)

}
\seealso{
Other Layer correlation functions: 
\code{\link{annotate_registered_clusters}()},
\code{\link{layer_stat_cor}()}
}
\author{
Louise Huuki-Myers
}
\concept{Layer correlation functions}
