% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration_wrapper.R
\name{registration_wrapper}
\alias{registration_wrapper}
\title{Spatial registration: wrapper function}
\usage{
registration_wrapper(
  sce,
  var_registration,
  var_sample_id,
  covars = NULL,
  gene_ensembl = NULL,
  gene_name = NULL,
  suffix = "",
  min_ncells = 10,
  pseudobulk_rds_file = NULL
)
}
\arguments{
\item{sce}{A
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment-class}
object or one that inherits its properties.}

\item{var_registration}{A \code{character(1)} specifying the \code{colData(sce)}
variable of interest against which will be used for computing the relevant
statistics. This should be a categorical variable, with all categories
syntaticly valid (could be used as an R variable, no special characters or
leading numbers), ex. 'L1.2', 'celltype2' not 'L1/2' or '2'.}

\item{var_sample_id}{A \code{character(1)} specifying the \code{colData(sce)} variable
with the sample ID.}

\item{covars}{A \code{character()} with names of sample-level covariates.}

\item{gene_ensembl}{A \code{character(1)} specifying the \code{rowData(sce_pseudo)}
column with the ENSEMBL gene IDs. This will be used by \code{layer_stat_cor()}.}

\item{gene_name}{A \code{character(1)} specifying the \code{rowData(sce_pseudo)}
column with the gene names (symbols).}

\item{suffix}{A \code{character(1)} specifying the suffix to use for the
F-statistics column. This is particularly useful if you will run this
function more than once and want to be able to merge the results.}

\item{min_ncells}{An \code{integer(1)} greater than 0 specifying the minimum
number of cells (for scRNA-seq) or spots (for spatial) that are combined
when pseudo-bulking. Pseudo-bulked samples with less than \code{min_ncells} on
\code{sce_pseudo$ncells} will be dropped.}

\item{pseudobulk_rds_file}{A \code{character(1)} specifying the path for saving
an RDS file with the pseudo-bulked object. It's useful to specify this since
pseudo-bulking can take hours to run on large datasets.}
}
\value{
A \code{list()} of \code{data.frame()} with the statistical results. This is
similar to \code{fetch_data("modeling_results")}.
}
\description{
This function is provided for convenience. It runs all the functions
required for computing the \code{modeling_results}. This can be useful for
finding marker genes on a new spatially-resolved transcriptomics dataset
and thus using it for \code{run_app()}. The results from this function can also be
used for performing spatial registration through \code{layer_stat_cor()} and
related functions of sc/snRNA-seq datasets.
}
\details{
We chose a default of \code{min_ncells = 10} based on OSCA from section 4.3
at
\url{http://bioconductor.org/books/3.15/OSCA.multisample/multi-sample-comparisons.html}.
They cite \url{https://doi.org/10.1038/s41467-020-19894-4} as the paper where
they came up with the definition of "very low" being 10. You might want
to use \code{registration_pseudobulk()} and manually explore \code{sce_pseudo$ncells}
to choose the best cutoff.
}
\examples{
## Ensure reproducibility of example data
set.seed(20220907)

## Generate example data
sce <- scuttle::mockSCE()

## Add some sample IDs
sce$sample_id <- sample(LETTERS[1:5], ncol(sce), replace = TRUE)

## Add a sample-level covariate: age
ages <- rnorm(5, mean = 20, sd = 4)
names(ages) <- LETTERS[1:5]
sce$age <- ages[sce$sample_id]

## Add gene-level information
rowData(sce)$ensembl <- paste0("ENSG", seq_len(nrow(sce)))
rowData(sce)$gene_name <- paste0("gene", seq_len(nrow(sce)))

## Compute all modeling results
example_modeling_results <- registration_wrapper(
    sce,
    var_registration = "Cell_Cycle",
    var_sample_id = "sample_id",
    covars = c("age"),
    gene_ensembl = "ensembl",
    gene_name = "gene_name",
    suffix = "wrapper"
)

## Explore the results from registration_wrapper()
class(example_modeling_results)
length(example_modeling_results)
names(example_modeling_results)
lapply(example_modeling_results, head)
}
\seealso{
Other spatial registration and statistical modeling functions: 
\code{\link{registration_block_cor}()},
\code{\link{registration_model}()},
\code{\link{registration_pseudobulk}()},
\code{\link{registration_stats_anova}()},
\code{\link{registration_stats_enrichment}()},
\code{\link{registration_stats_pairwise}()}
}
\concept{spatial registration and statistical modeling functions}
