% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqpac_S4classes.R
\docType{class}
\name{PAC-class}
\alias{PAC-class}
\alias{PAC}
\title{S4 object for PAC}
\usage{
PAC(Pheno, Anno, Counts, norm, summary)
}
\arguments{
\item{Pheno}{Phenotype data.frame table with sample ID as row names and where
columns are variables associated with the samples. Can be generated using
the make_pheno function.}

\item{Anno}{Annotation data.frame table with unique sequences as row names
and where columns are variables associated with the sequences.}

\item{Counts}{Counts table (data.frame) with unique sequences as row names
(identical to Anno) and where columns are sample ID (identical to row names
for Pheno. Should contain raw counts and can be generated using the
make_counts function.}

\item{norm}{List of data.frames. May be regarded as a "folder" with
normalized counts tables. The listed data.frames must have identical
sequence names as Counts/Anno (rows) and sample IDs (columns) as
Counts/Pheno. Can be generated using the PAC_norm function, but seqpac
functions will attempt use any normalized table stored in norm that are in
agreement with the above cafeterias.}

\item{summary}{List of data.frames, just like norm, but contains summarized
raw or normalized counts (e.g. means, standard errors, fold changes).
Important, the listed data.frames must have identical sequence names as
Counts/Anno (rows), but columns don't need sample IDs. Can be generated
using the PAC_summary function, but seqpac functions will attempt use any
summarized table stored in the summary "folder".}
}
\value{
Generates a S4 PAC-object.
}
\description{
S4 version of the PAC object.
}
\details{
Just like the S3 version, all sub-tables must have identical sequence (row)
names. To extract tables from S4 objects, use the getter commands or use @
(e.g. PAC@Pheno) just like $ for the S3 version (e.g. pheno(PAC)). You may
also use a coercion method, e.g. \code{PAC_S3 <- as(PAC_S4, "list")}

Holds up to 5 slots: \describe{
   \item{\strong{Pheno}}{data.frame > information about the samples}
   \item{\strong{Anno}}{data.frame > sequences annotations}
   \item{\strong{Counts}}{data.frame > sequence counts over samples}
   \item{\emph{norm (optional)}}{list of data.frames > normalized counts}
   \item{\emph{summary (optional)}}{
   list of data.frames > summarized counts or normalized counts}
   }
}
\examples{
load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                  package = "seqpac", mustWork = TRUE))
                  
# check type
class(pac)
isS4(pac)
 
 
# Turns S4 PAC object into a S3
pac_s3 <- as(pac, "list")

# Turns S3 PAC object into a S4
pac_s4 <- as.PAC(pac_s3)


}
