% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAC_norm.R
\name{PAC_norm}
\alias{PAC_norm}
\title{Generates normalized values from a PAC object}
\usage{
PAC_norm(PAC, norm = "cpm", merge_pac = TRUE)
}
\arguments{
\item{PAC}{PAC-list object containing an Anno data.frame with sequences as
row names and a Count table with raw counts.}

\item{norm}{Character indicating what type of normalization method that
should be applied to the counts(PAC). If norm="cpm", counts per million
reads is returned. Each sequence is then divided against the total number
of counts in a given sample. If norm="vst", counts(PAC) will be imported
into the \code{\link[DESeq2]{varianceStabilizingTransformation}} function
in the DESeq2-package with the options blind=TRUE and fitType="mean". If
norm="rlog", counts(PAC) will instead be imported into the
\code{\link[DESeq2]{rlog}} function also available in
DESeq2-package (options blind=TRUE and fitType="mean") for a log2
transformed version of vst, and is more robust to varying library sizes.}

\item{merge_pac}{logical whether the normalized table should be returned and
stored in the norm(PAC) 'folder' of the provided PAC object (TRUE) or be
returned as a data frame.}
}
\value{
A normalized count table, or if pac_merge=TRUE, a PAC object with
  normalized counts table added to the norm folder (norm(PAC)).
}
\description{
\code{PAC_norm} generates normalized values from a PAC object
}
\details{
Using the counts in a PAC object to generate normalized values in a data.frame
with the same rownames as in the original PAC object
}
\examples{
load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                  package = "seqpac", mustWork = TRUE))
pac_norm  <- PAC_norm(pac, norm="cpm") 
df_norm <- PAC_norm(pac, norm = "vst", merge_pac = FALSE)


}
\seealso{
\url{https://github.com/OestLab/seqpac} for updates on the current
  package.

Other PAC analysis: 
\code{\link{PAC_covplot}()},
\code{\link{PAC_deseq}()},
\code{\link{PAC_filter}()},
\code{\link{PAC_filtsep}()},
\code{\link{PAC_gtf}()},
\code{\link{PAC_jitter}()},
\code{\link{PAC_mapper}()},
\code{\link{PAC_nbias}()},
\code{\link{PAC_pca}()},
\code{\link{PAC_pie}()},
\code{\link{PAC_saturation}()},
\code{\link{PAC_sizedist}()},
\code{\link{PAC_stackbar}()},
\code{\link{PAC_summary}()},
\code{\link{PAC_trna}()},
\code{\link{as.PAC}()},
\code{\link{filtsep_bin}()},
\code{\link{map_rangetype}()},
\code{\link{tRNA_class}()}
}
\concept{PAC analysis}
