% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAC_stackbar.R
\name{PAC_stackbar}
\alias{PAC_stackbar}
\title{Plot stackbars from PAC}
\usage{
PAC_stackbar(
  PAC,
  anno_target = NULL,
  pheno_target = NULL,
  summary_target = NULL,
  color = NULL,
  width = 1,
  no_anno = TRUE,
  total = TRUE,
  norm = "counts",
  style = "percent"
)
}
\arguments{
\item{PAC}{PAC-list object.}

\item{anno_target}{List with: 
1st object being character vector of target
column(s) in Anno, 2nd object being a character
vector of the target biotype(s) in the target column
(1st object). Important, the 2nd object is order
sensitive, meaning that categories will appear in
the same order in the stacked bar graph.
(default=NULL)}

\item{pheno_target}{List with: 
1st object being character vector of target
column(s) in Pheno, 2nd object being a character
vector of the target group(s) in the target column
(1st object). Important, the 2nd object is order
sensitive, meaning that categories will appear in
the same order in the stacked bar graph.
(default=NULL)}

\item{summary_target}{List with: 
1st object being character vector of target
column(s) in Summary. This is produced by
\code{PAC_summary}. If no summary_target is 
defined, samples will be plotted individually.
(default=NULL)}

\item{color}{Character vector with rgb color hex codes in the same length
as the number of biotypes. For example see:
https://www.coolgenerator.com/rgb-color-generator. color=NULL will
generate the default color scheme.}

\item{width}{Integer adjusting the width of the bars (default=1). Works best
with few or singular bars.}

\item{no_anno}{Logical. If TRUE sequences with no annotations will be
plotted, while FALSE will skip sequences with 'no_anno' in the column
defined by anno_target (default=TRUE). Note that you can always use
\code{PAC_filter} to remove anno_targets from PAC prior to plotting.}

\item{total}{Logical, whether the total counts should be added at the bottom
of each graph (default=TRUE).}

\item{norm}{Character vector defining what data to base analysis on, e.g 
"counts" for raw counts (default), "cpm" for normalized data or any other
column in norm section of PAC object.}

\item{style}{Character vector defining how data is to be presented in stack
bar, where default is "percent", showing the percentage of the anno_target
of all reads. Other option is "total", where the total amount of
counts/normalized reads are stacked in one stack per anno_target.}
}
\value{
A stacked bar plot generated by ggplot2
}
\description{
\code{PAC_stackbar} Generates a graph that stack classes up to 100% or on total reads.
}
\details{
Given a PAC object the function will attempt to extract group information
from Pheno, class information from Anno, or summarized data to generate a 
stacked (percent or total counts) bar.
}
\examples{

load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                 package = "seqpac", mustWork = TRUE))

##########################################
### Stacked bars in seqpac 
##----------------------------------------

# Choose an anno_target and plot samples
PAC_stackbar(pac, anno_target=list("Biotypes_mis0"))

# 'no_anno' and 'other' will always end on top not matter the order
ord_bio <- as.character(sort(unique(anno(pac)$Biotypes_mis3)))
p1 <- PAC_stackbar(pac, anno_target=list("Biotypes_mis0", ord_bio))
p2 <- PAC_stackbar(pac, anno_target=list("Biotypes_mis0", rev(ord_bio)))
cowplot::plot_grid(plotlist=list(p1, p2))
# (Hint: if you don't want them to appear on top, rename them)

# Reorder samples by pheno_targets
PAC_stackbar(pac, pheno_target=list("batch"), 
             anno_target=list("Biotypes_mis0"))

# Summarized over pheno_target 
# (as default PAC_stackbar orders by pheno_target but plots all samples, 
#  unless a summary_target is defined)

pac <- PAC_summary(pac, pheno_target=list("stage"))
PAC_stackbar(pac, anno_target=list("Biotypes_mis0"),
             summary_target=list("countsMeans_stage"))

# Summarized over a grand mean of all samples

pac <- PAC_summary(pac)
PAC_stackbar(pac, anno_target=list("Biotypes_mis0"), 
        summary_target=list("countsMeans_All"))

}
\seealso{
\url{https://github.com/OestLab/seqpac} for updates on the current
  package.

Other PAC analysis: 
\code{\link{PAC_covplot}()},
\code{\link{PAC_deseq}()},
\code{\link{PAC_filter}()},
\code{\link{PAC_filtsep}()},
\code{\link{PAC_gtf}()},
\code{\link{PAC_jitter}()},
\code{\link{PAC_mapper}()},
\code{\link{PAC_nbias}()},
\code{\link{PAC_norm}()},
\code{\link{PAC_pca}()},
\code{\link{PAC_pie}()},
\code{\link{PAC_saturation}()},
\code{\link{PAC_sizedist}()},
\code{\link{PAC_summary}()},
\code{\link{PAC_trna}()},
\code{\link{as.PAC}()},
\code{\link{filtsep_bin}()},
\code{\link{map_rangetype}()},
\code{\link{tRNA_class}()}
}
\concept{PAC analysis}
