% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrapeDependencies.R
\name{scrapeDependencies}
\alias{scrapeDependencies}
\title{Scrape dependencies}
\usage{
scrapeDependencies(dir)
}
\arguments{
\item{dir}{String containing the path to the directory containing Rmarkdown reports.
This is searched recursively for all files ending in \code{".Rmd"}.}
}
\value{
Character vector of required packages.
}
\description{
Scrape Rmarkdown reports in the book for all required dependencies.
}
\details{
The output of this should be added to the \code{Suggests} field of the book's \code{DESCRIPTION}, 
to make it easier to simply install all of its required dependencies.

Note that dependencies in inline code sections are not detected,
so these should be explicitly mentioned in a standalone code chunk to be captured.
}
\author{
Aaron Lun
tmp <- tempfile(fileext=".Rmd")
write(file=tmp, "```{r}
A::a()
```

```{r}
library(B)
require(C)
```")

scrapeDependencies(tempdir())
}
