/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent;

import edu.oswego.cs.dl.util.concurrent.Barrier;
import edu.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import edu.oswego.cs.dl.util.concurrent.Semaphore;
import edu.oswego.cs.dl.util.concurrent.TimeoutException;
import edu.oswego.cs.dl.util.concurrent.WaiterPreferenceSemaphore;

public class Rendezvous
implements Barrier {
    protected final int parties_;
    protected boolean broken_ = false;
    protected int entries_ = 0;
    protected long departures_ = 0L;
    protected final Semaphore entryGate_;
    protected final Object[] slots_;
    protected RendezvousFunction rendezvousFunction_;

    public Rendezvous(int n) {
        this(n, new Rotator());
    }

    public Rendezvous(int n, RendezvousFunction rendezvousFunction) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties_ = n;
        this.rendezvousFunction_ = rendezvousFunction;
        this.entryGate_ = new WaiterPreferenceSemaphore(n);
        this.slots_ = new Object[n];
    }

    public Object attemptRendezvous(Object object, long l) throws InterruptedException, TimeoutException, BrokenBarrierException {
        return this.doRendezvous(object, true, l);
    }

    public synchronized boolean broken() {
        return this.broken_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doRendezvous(Object object, boolean bl, long l) throws InterruptedException, TimeoutException, BrokenBarrierException {
        long l2;
        if (bl) {
            l2 = System.currentTimeMillis();
            if (!this.entryGate_.attempt(l)) {
                throw new TimeoutException(l);
            }
        } else {
            l2 = 0L;
            this.entryGate_.acquire();
        }
        Rendezvous rendezvous = this;
        synchronized (rendezvous) {
            int n;
            Object object2;
            block24: {
                int n2;
                Throwable throwable2;
                block23: {
                    object2 = null;
                    n = this.entries_++;
                    this.slots_[n] = object;
                    try {
                        if (this.entries_ == this.parties_) {
                            this.departures_ = this.entries_;
                            this.notifyAll();
                            try {
                                if (!this.broken_ && this.rendezvousFunction_ != null) {
                                    this.rendezvousFunction_.rendezvousFunction(this.slots_);
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                this.broken_ = true;
                            }
                        } else {
                            while (!this.broken_) {
                                if (this.departures_ >= 1L) {
                                    break;
                                }
                                long l3 = 0L;
                                if (bl && (l3 = l - (System.currentTimeMillis() - l2)) <= 0L) {
                                    this.broken_ = true;
                                    this.departures_ = this.entries_;
                                    this.notifyAll();
                                    throw new TimeoutException(l);
                                }
                                try {
                                    this.wait(l3);
                                }
                                catch (InterruptedException interruptedException) {
                                    if (!this.broken_ && this.departures_ <= 0L) {
                                        this.broken_ = true;
                                        this.departures_ = this.entries_;
                                        this.notifyAll();
                                        throw interruptedException;
                                    }
                                    Thread.currentThread().interrupt();
                                    break;
                                }
                            }
                        }
                        Object var14_12 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var14_13 = null;
                        object2 = this.slots_[n];
                        if (--this.departures_ > 0L) throw throwable2;
                        n2 = 0;
                        break block23;
                    }
                    object2 = this.slots_[n];
                    if (--this.departures_ <= 0L) {
                        int n3 = 0;
                        while (true) {
                            if (n3 >= this.slots_.length) {
                                this.entryGate_.release(this.entries_);
                                this.entries_ = 0;
                                break block24;
                            }
                            this.slots_[n3] = null;
                            ++n3;
                        }
                    }
                    break block24;
                }
                while (true) {
                    if (n2 >= this.slots_.length) break;
                    this.slots_[n2] = null;
                    ++n2;
                }
                this.entryGate_.release(this.entries_);
                this.entries_ = 0;
                throw throwable2;
            }
            if (!this.broken_) return object2;
            throw new BrokenBarrierException(n);
        }
    }

    public int parties() {
        return this.parties_;
    }

    public Object rendezvous(Object object) throws InterruptedException, BrokenBarrierException {
        return this.doRendezvous(object, false, 0L);
    }

    public void restart() {
        while (true) {
            Rendezvous rendezvous = this;
            synchronized (rendezvous) {
                if (this.entries_ == 0) {
                    this.broken_ = false;
                    return;
                }
                this.notifyAll();
            }
            Thread.yield();
        }
    }

    public synchronized RendezvousFunction setRendezvousFunction(RendezvousFunction rendezvousFunction) {
        RendezvousFunction rendezvousFunction2 = this.rendezvousFunction_;
        this.rendezvousFunction_ = rendezvousFunction;
        return rendezvousFunction2;
    }

    public static class Rotator
    implements RendezvousFunction {
        public void rendezvousFunction(Object[] objectArray) {
            int n = objectArray.length - 1;
            Object object = objectArray[0];
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = objectArray[n2 + 1];
                ++n2;
            }
            objectArray[n] = object;
        }
    }

    public static interface RendezvousFunction {
        public void rendezvousFunction(Object[] var1);
    }
}

