/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import eponine.model.BasisFunctionWithHistory;
import eponine.model.Constraint;
import eponine.model.ConstraintBasisFunction;
import eponine.model.TolerantDistribution;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.dist.OrderNDistributionFactory;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import stats.glm.BasisFunction;

public class ModelTools {
    public static final DistributionFactory DIST_FACTORY = new EDistributionFactory();

    private ModelTools() {
    }

    public static Constraint getConstraint(BasisFunction basisFunction) {
        return ModelTools.getConstraintBasis(basisFunction).getConstraint();
    }

    public static ConstraintBasisFunction getConstraintBasis(BasisFunction basisFunction) {
        if (basisFunction instanceof ConstraintBasisFunction) {
            return (ConstraintBasisFunction)basisFunction;
        }
        if (basisFunction instanceof BasisFunctionWithHistory) {
            return ModelTools.getConstraintBasis(((BasisFunctionWithHistory)basisFunction).getBasisFunction());
        }
        throw new IllegalArgumentException("Doesn't wrap a constraint");
    }

    public static BasisFunction removeHistory(BasisFunction basisFunction) {
        if (basisFunction instanceof BasisFunctionWithHistory) {
            return ModelTools.getConstraintBasis(((BasisFunctionWithHistory)basisFunction).getBasisFunction());
        }
        return basisFunction;
    }

    public static double gauss() {
        return Math.cos(Math.random() * 6.28) * Math.sqrt(2.0 * Math.log(1.0 / Math.random()));
    }

    public static double distrib(double d, int n) {
        double d2 = (double)n / d;
        return 0.15915494309189535 * Math.exp(-d2 * d2 / 2.0);
    }

    public static WeightMatrix flattenHigherOrderWM(WeightMatrix weightMatrix) throws IllegalAlphabetException, IllegalSymbolException {
        Alphabet alphabet = weightMatrix.getAlphabet();
        List list = alphabet.getAlphabets();
        if (list.size() == 1) {
            throw new IllegalAlphabetException(alphabet.getName() + " is already flat.");
        }
        FiniteAlphabet finiteAlphabet = (FiniteAlphabet)list.get(0);
        int n = 1;
        while (n < list.size()) {
            if (list.get(n) != finiteAlphabet) {
                throw new IllegalAlphabetException("Cross product " + alphabet.getName() + " is not uniform.");
            }
            ++n;
        }
        if (list.size() != 2) {
            throw new IllegalAlphabetException("Can't flatten > 2nd order at the moment.");
        }
        Distribution distribution = new UniformDistribution(finiteAlphabet);
        SimpleWeightMatrix simpleWeightMatrix = new SimpleWeightMatrix(finiteAlphabet, weightMatrix.columns(), DIST_FACTORY);
        int n2 = 0;
        while (n2 < weightMatrix.columns()) {
            OrderNDistribution orderNDistribution = (OrderNDistribution)weightMatrix.getColumn(n2);
            Distribution distribution2 = simpleWeightMatrix.getColumn(n2);
            SimpleDistributionTrainerContext simpleDistributionTrainerContext = new SimpleDistributionTrainerContext();
            simpleDistributionTrainerContext.setNullModelWeight(0.0);
            simpleDistributionTrainerContext.registerDistribution(distribution2);
            Iterator iterator = finiteAlphabet.iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                double d = distribution.getWeight(symbol);
                Distribution distribution3 = orderNDistribution.getDistribution(symbol);
                Iterator iterator2 = finiteAlphabet.iterator();
                while (iterator2.hasNext()) {
                    Symbol symbol2 = (Symbol)iterator2.next();
                    double d2 = distribution3.getWeight(symbol2);
                    double d3 = d * d2;
                    simpleDistributionTrainerContext.addCount(distribution2, symbol2, d3);
                }
            }
            try {
                simpleDistributionTrainerContext.train();
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioError("Uncooperative weight matrices");
            }
            distribution = distribution2;
            ++n2;
        }
        return simpleWeightMatrix;
    }

    static class EDistributionFactory
    implements DistributionFactory {
        EDistributionFactory() {
        }

        public Distribution createDistribution(Alphabet alphabet) throws IllegalAlphabetException {
            if (alphabet.getAlphabets().size() > 1) {
                return OrderNDistributionFactory.DEFAULT.createDistribution(alphabet);
            }
            return new TolerantDistribution((FiniteAlphabet)alphabet);
        }
    }
}

