/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import java.util.Arrays;
import java.util.List;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.twohead.Cell;
import org.biojava.bio.dp.twohead.EmissionCache;
import org.biojava.bio.dp.twohead.PairDPCursor;
import org.biojava.bio.dp.twohead.PairDPMatrix;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public abstract class AbstractMatrixPairDPCursor
implements PairDPCursor {
    protected int[] pos;
    protected SymbolList[] seqs;
    protected double[][][] columns;
    protected BackPointer[][][] bPointers;
    protected double[][][] emissions;
    protected int numStates;
    protected double[] zeroCol;
    protected BackPointer[] emptyBP;
    protected int[] depth;
    protected double[][][] sMatrix;
    protected EmissionCache eCache;

    public AbstractMatrixPairDPCursor(SymbolList symbolList, SymbolList symbolList2, int n, int n2, int n3, int n4, PairDPMatrix pairDPMatrix, EmissionCache emissionCache) throws IllegalSymbolException {
        this.numStates = pairDPMatrix.states().length;
        this.zeroCol = new double[this.numStates];
        int n5 = 0;
        while (n5 < this.zeroCol.length) {
            this.zeroCol[n5] = Double.NaN;
            ++n5;
        }
        this.emptyBP = new BackPointer[this.numStates];
        this.sMatrix = pairDPMatrix.getScoreArray();
        this.pos = new int[2];
        this.pos[0] = n;
        this.pos[1] = n2;
        this.seqs = new SymbolList[2];
        this.seqs[0] = symbolList;
        this.seqs[1] = symbolList2;
        this.depth = new int[2];
        this.depth[0] = n3;
        this.depth[1] = n4;
        this.bPointers = new BackPointer[symbolList.length() + 2][symbolList2.length() + 2][this.numStates];
        this.emissions = new double[symbolList.length() + 2][symbolList2.length() + 2][];
        this.eCache = emissionCache;
        Symbol[] symbolArray = new Symbol[2];
        List<Symbol> list = Arrays.asList(symbolArray);
        int n6 = 0;
        while (n6 <= symbolList.length() + 1) {
            symbolArray[0] = n6 < 1 || n6 > symbolList.length() ? AlphabetManager.getGapSymbol() : symbolList.symbolAt(n6);
            double[][] dArray = this.emissions[n6];
            int n7 = 0;
            while (n7 <= symbolList2.length() + 1) {
                symbolArray[1] = n7 < 1 || n7 > symbolList2.length() ? AlphabetManager.getGapSymbol() : symbolList2.symbolAt(n7);
                dArray[n7] = emissionCache.getEmissions(list);
                ++n7;
            }
            ++n6;
        }
    }

    public int[] getDepth() {
        return this.depth;
    }

    public abstract boolean hasNext();

    public abstract void next(Cell[][] var1) throws IllegalSymbolException;

    public Cell[][] press() {
        Cell[][] cellArray = new Cell[this.depth[0]][this.depth[1]];
        int n = 0;
        while (n < cellArray.length) {
            Cell[] cellArray2 = cellArray[n];
            int n2 = 0;
            while (n2 < cellArray2.length) {
                cellArray2[n2] = new Cell();
                ++n2;
            }
            ++n;
        }
        return cellArray;
    }
}

