/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.List;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceRendererWrapper;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.gui.sequence.SubSequenceRenderContext;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.NestedError;

public class FilteringRenderer
extends SequenceRendererWrapper {
    public static ChangeType FILTER = new ChangeType("The filter has changed", "org.biojava.bio.gui.sequence.FilteringRenderer", "FILTER", SequenceRenderContext.LAYOUT);
    public static ChangeType RECURSE = new ChangeType("The recurse flag has changed", "org.biojava.bio.gui.sequence.FilteringRenderer", "RECURSE", SequenceRenderContext.LAYOUT);
    protected FeatureFilter filter;
    protected boolean recurse;

    public FilteringRenderer() {
        this.filter = FeatureFilter.all;
        this.recurse = false;
    }

    public FilteringRenderer(SequenceRenderer sequenceRenderer, FeatureFilter featureFilter, boolean bl) {
        super(sequenceRenderer);
        try {
            this.setFilter(featureFilter);
            this.setRecurse(bl);
        }
        catch (ChangeVetoException changeVetoException) {
            throw new NestedError(changeVetoException, "Assertion Failure: Should have no listeners");
        }
    }

    protected SequenceRenderContext getContext(SequenceRenderContext sequenceRenderContext) {
        if (this.filter == FeatureFilter.all && this.recurse) {
            return sequenceRenderContext;
        }
        return new SubSequenceRenderContext(sequenceRenderContext, ((Sequence)sequenceRenderContext.getSequence()).filter(this.filter, this.recurse));
    }

    public double getDepth(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return super.getDepth(this.getContext(sequenceRenderContext), rangeLocation);
    }

    public FeatureFilter getFilter() {
        return this.filter;
    }

    public double getMinimumLeader(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return super.getMinimumLeader(this.getContext(sequenceRenderContext), rangeLocation);
    }

    public double getMinimumTrailer(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return super.getMinimumTrailer(this.getContext(sequenceRenderContext), rangeLocation);
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    public void paint(Graphics2D graphics2D, SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        super.paint(graphics2D, this.getContext(sequenceRenderContext), rangeLocation);
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext sequenceRenderContext, MouseEvent mouseEvent, List list, RangeLocation rangeLocation) {
        return super.processMouseEvent(this.getContext(sequenceRenderContext), mouseEvent, list, rangeLocation);
    }

    public void setFilter(FeatureFilter featureFilter) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(FILTER);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, FILTER, this.filter, featureFilter);
                changeSupport.firePreChangeEvent(changeEvent);
                this.filter = featureFilter;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.filter = featureFilter;
        }
    }

    public void setRecurse(boolean bl) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RECURSE);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, RECURSE, new Boolean(bl), new Boolean(this.recurse));
                changeSupport.firePreChangeEvent(changeEvent);
                this.recurse = bl;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.recurse = bl;
        }
    }
}

