/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.Index;
import org.biojava.bio.seq.db.IndexStore;
import org.biojava.bio.seq.db.SimpleIndex;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.utils.NestedError;
import org.biojava.utils.OverlayMap;

public class TabIndexStore
implements IndexStore,
Serializable {
    private transient Map idToIndex;
    private transient Map commited;
    private transient Map uncommited;
    private final File storeFile;
    private final File indexFile;
    private final String name;
    private final Set files;
    private File[] seqFileIndex;
    private final SequenceFormat format;
    private final SequenceBuilderFactory sbFactory;
    private final SymbolParser symbolParser;

    public TabIndexStore(File file, File file2, String string, SequenceFormat sequenceFormat, SequenceBuilderFactory sequenceBuilderFactory, SymbolParser symbolParser) throws IOException, BioException {
        if (file.exists() || file2.exists()) {
            throw new BioException("Files already exist");
        }
        this.storeFile = file;
        this.indexFile = file2;
        this.name = string;
        this.format = sequenceFormat;
        this.sbFactory = sequenceBuilderFactory;
        this.symbolParser = symbolParser;
        this.files = new HashSet();
        this.seqFileIndex = new File[0];
        this.commited = new HashMap();
        this.uncommited = new HashMap();
        this.idToIndex = new OverlayMap(this.commited, this.uncommited);
        this.commit();
    }

    protected void addFile(File file) {
        if (!this.files.contains(file)) {
            int n = this.seqFileIndex.length;
            this.files.add(file);
            File[] fileArray = new File[n + 1];
            System.arraycopy(this.seqFileIndex, 0, fileArray, 0, n);
            fileArray[n] = file;
            this.seqFileIndex = fileArray;
        }
    }

    public void commit() throws BioException {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.indexFile.toString(), true));
            Iterator iterator = this.uncommited.values().iterator();
            while (iterator.hasNext()) {
                Index index = (Index)iterator.next();
                printWriter.println(String.valueOf(this.getFileIndex(index.getFile())) + "\t" + index.getStart() + "\t" + index.getID());
            }
            this.commitStore();
            printWriter.close();
            this.commited.putAll(this.uncommited);
            this.uncommited.clear();
        }
        catch (IOException iOException) {
            throw new BioException(iOException, "Failed to commit");
        }
    }

    protected void commitStore() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.storeFile);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
        fileOutputStream.close();
    }

    public Index fetch(String string) throws IllegalIDException, BioException {
        Index index = (Index)this.idToIndex.get(string);
        if (index == null) {
            throw new IllegalIDException("No Index known for id '" + string + "'");
        }
        return index;
    }

    protected int getFileIndex(File file) {
        int n = this.seqFileIndex.length - 1;
        while (n >= 0) {
            File file2 = this.seqFileIndex[n];
            if (file2 == file || file.equals(file2)) {
                return n;
            }
            --n;
        }
        throw new IndexOutOfBoundsException("Index not found for File '" + file + "'");
    }

    public Set getFiles() {
        return Collections.unmodifiableSet(this.files);
    }

    public SequenceFormat getFormat() {
        return this.format;
    }

    public Set getIDs() {
        return Collections.unmodifiableSet(this.idToIndex.keySet());
    }

    public String getName() {
        return this.name;
    }

    public SequenceBuilderFactory getSBFactory() {
        return this.sbFactory;
    }

    public SymbolParser getSymbolParser() {
        return this.symbolParser;
    }

    protected void initialize() throws IOException {
        if (this.indexFile.exists()) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.indexFile));
            String string = bufferedReader.readLine();
            while (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                int n = Integer.parseInt(stringTokenizer.nextToken());
                long l = Long.parseLong(stringTokenizer.nextToken());
                String string2 = stringTokenizer.nextToken();
                SimpleIndex simpleIndex = new SimpleIndex(this.seqFileIndex[n], l, string2);
                this.commited.put(string2, simpleIndex);
                string = bufferedReader.readLine();
            }
        }
    }

    public static TabIndexStore open(File file) throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            TabIndexStore tabIndexStore = (TabIndexStore)objectInputStream.readObject();
            fileInputStream.close();
            return tabIndexStore;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NestedError(classNotFoundException, "Assertion Failure: How did we get here?");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.commited = new HashMap();
        this.uncommited = new HashMap();
        this.idToIndex = new OverlayMap(this.commited, this.uncommited);
        this.initialize();
    }

    public void rollback() {
        this.uncommited.clear();
    }

    public void store(Index index) throws IllegalIDException, BioException {
        if (this.idToIndex.containsKey(index.getID())) {
            throw new IllegalIDException("ID already in use: '" + index.getID() + "'");
        }
        this.addFile(index.getFile());
        this.uncommited.put(index.getID(), index);
    }
}

