/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class FixedWidthParser
implements SymbolParser,
Serializable {
    private Alphabet alpha;
    private int tokenLength;
    private Map tokenToSymbol = new HashMap();

    public FixedWidthParser(Alphabet alphabet, int n) {
        this.alpha = alphabet;
        this.tokenLength = n;
    }

    public void addTokenMap(String string, Symbol symbol) throws IllegalSymbolException, IllegalArgumentException {
        this.getAlphabet().validate(symbol);
        if (string.length() != this.tokenLength) {
            throw new IllegalArgumentException("token '" + string + "' must be of length " + this.tokenLength);
        }
        this.tokenToSymbol.put(string, symbol);
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public SymbolList parse(String string) throws IllegalSymbolException {
        SimpleSymbolList simpleSymbolList = new SimpleSymbolList(this.alpha);
        int n = 0;
        while (n < string.length()) {
            simpleSymbolList.addSymbol(this.parseToken(string.substring(n, n + this.tokenLength)));
            n += this.tokenLength;
        }
        return simpleSymbolList;
    }

    public StreamParser parseStream(SeqIOListener seqIOListener) {
        return new FWStreamParser(seqIOListener);
    }

    public Symbol parseToken(String string) throws IllegalSymbolException {
        Symbol symbol = (Symbol)this.tokenToSymbol.get(string);
        if (symbol == null) {
            throw new IllegalSymbolException("No symbol associated with token " + string);
        }
        return symbol;
    }

    private class FWStreamParser
    implements StreamParser {
        private SeqIOListener listener;
        private char[] leftOver;
        private char leftOverLen;
        private Symbol[] buffer = new Symbol[256];

        public FWStreamParser(SeqIOListener seqIOListener) {
            this.listener = seqIOListener;
            this.leftOver = new char[FixedWidthParser.this.tokenLength];
            this.leftOverLen = '\u0000';
        }

        /*
         * Unable to fully structure code
         */
        public void characters(char[] var1_1, int var2_2, int var3_3) throws IllegalSymbolException {
            var4_4 = 0;
            var5_5 = 0;
            if (this.leftOverLen > '\u0000') {
                while (this.leftOverLen < FixedWidthParser.access$0(FixedWidthParser.this) && var4_4 < var3_3) {
                    v0 = this.leftOverLen;
                    this.leftOverLen = (char)(v0 + '\u0001');
                    this.leftOver[v0] = var1_1[var2_2 + var4_4++];
                }
                if (this.leftOverLen == FixedWidthParser.access$0(FixedWidthParser.this)) {
                    this.buffer[var5_5++] = FixedWidthParser.this.parseToken(new String(this.leftOver));
                    this.leftOverLen = '\u0000';
                }
            }
            while (var3_3 - var4_4 >= FixedWidthParser.access$0(FixedWidthParser.this) && var5_5 < this.buffer.length) {
                this.buffer[var5_5++] = FixedWidthParser.this.parseToken(new String(var1_1, var2_2 + var4_4, FixedWidthParser.access$0(FixedWidthParser.this)));
                var4_4 += FixedWidthParser.access$0(FixedWidthParser.this);
            }
            if (var5_5 > 0) {
                try {
                    this.listener.addSymbols(FixedWidthParser.this.getAlphabet(), this.buffer, 0, var5_5);
                }
                catch (IllegalAlphabetException var6_6) {
                    throw new BioError(var6_6);
                }
            }
            if (var3_3 - var4_4 < FixedWidthParser.access$0(FixedWidthParser.this)) ** GOTO lbl28
            this.characters(var1_1, var2_2 + var4_4, var3_3 - var4_4);
            return;
lbl-1000:
            // 1 sources

            {
                v1 = this.leftOverLen;
                this.leftOverLen = (char)(v1 + '\u0001');
                this.leftOver[v1] = var1_1[var2_2 + var4_4++];
lbl28:
                // 2 sources

                ** while (var3_3 - var4_4 > 0)
            }
lbl29:
            // 1 sources

        }

        public void close() throws IllegalSymbolException {
            if (this.leftOverLen > '\u0000') {
                throw new IllegalSymbolException("FixedWidth stream parser has " + this.leftOverLen + " orphan characters at end of stream");
            }
        }
    }
}

