/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.scenegraph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import org.biojava.utils.scenegraph.ChildManager;
import org.biojava.utils.scenegraph.Component;
import org.biojava.utils.scenegraph.Composite;
import org.biojava.utils.scenegraph.CompositeRectangularBorder;
import org.biojava.utils.scenegraph.GlyphSelectionEvent;
import org.biojava.utils.scenegraph.GlyphSelectionListener;
import org.biojava.utils.scenegraph.Primative;

public class GlyphComponent
extends JComponent
implements Scrollable {
    private Component rotate = new Composite();
    private Component scale = new Composite();
    private Component translate = new Composite();
    private Component first;
    private Component last;
    private Component root;
    private Component overlayRoot;
    private boolean boundsOverlay;
    private Vector glyphSelectionListener;

    public Component getRotate() {
        return this.rotate;
    }

    public Component getScale() {
        return this.scale;
    }

    public Component getTranslate() {
        return this.translate;
    }

    public void setTranslation(double d, double d2) {
        this.translate.alterTransform().setToTranslation(d, d2);
        this.resizeAndValidate();
    }

    public double getTranslateX() {
        return this.translate.getTransform().getTranslateX();
    }

    public double getTranslateY() {
        return this.translate.getTransform().getTranslateY();
    }

    public void setRotation(double d, double d2, double d3) {
        this.rotate.alterTransform().setToRotation(d, d2, d3);
        this.resizeAndValidate();
    }

    public void setScale(double d, double d2) {
        this.scale.alterTransform().setToScale(d, d2);
        this.resizeAndValidate();
    }

    public void setScale(double d, double d2, double d3, double d4) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-d3, -d4);
        affineTransform.concatenate(AffineTransform.getScaleInstance(d, d2));
        affineTransform.concatenate(AffineTransform.getTranslateInstance(d3, d4));
        this.scale.alterTransform().setTransform(affineTransform);
        this.resizeAndValidate();
    }

    public boolean isOpaque() {
        return true;
    }

    public final Component getRealRoot() {
        return this.first;
    }

    public final Component getRoot() {
        return this.root;
    }

    public final void setRoot(Component component) {
        ChildManager childManager = this.last.getChildManager();
        if (this.root != null) {
            childManager.remove(this.root);
        }
        if (component != null) {
            childManager.insert(-1000000, component);
        }
        this.root = component;
        this.setOverlayEnabled(this.getOverlayEnabled());
        this.resizeAndValidate();
    }

    protected void resizeAndValidate() {
        this.resize();
        this.revalidate();
        this.repaint();
    }

    public final void setOverlayEnabled(boolean bl) {
        this.boundsOverlay = bl;
        if (bl) {
            this.overlayRoot = this.buildOverlay(this.root);
            this.overlayRoot.getGraphicsChanges().paint = Color.blue;
            this.last.getChildManager().insert(-1000000, this.overlayRoot);
        } else if (this.overlayRoot != null) {
            this.last.getChildManager().remove(this.overlayRoot);
        }
        this.repaint();
    }

    public final Component buildOverlay(Component component) {
        CompositeRectangularBorder compositeRectangularBorder = new CompositeRectangularBorder();
        ChildManager childManager = ((Component)compositeRectangularBorder).getChildManager();
        Iterator iterator = component.getChildIterator();
        while (iterator.hasNext()) {
            Component component2 = (Component)iterator.next();
            childManager.insert(-1000000, this.buildOverlay(component2));
            childManager.insert(-2000000, new Primative(component2.getBounds()));
        }
        compositeRectangularBorder.setTransform(component.getDrawingTransform());
        return compositeRectangularBorder;
    }

    public final boolean getOverlayEnabled() {
        return this.boundsOverlay;
    }

    public GlyphComponent() {
        this.rotate.getChildManager().insert(-1000000, this.scale);
        this.scale.getChildManager().insert(-1000000, this.translate);
        this.first = this.rotate;
        this.last = this.translate;
        this.glyphSelectionListener = new Vector();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.processClick(mouseEvent, 501);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processClick(mouseEvent, 502);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processClick(mouseEvent, 500);
            }

            void processClick(MouseEvent mouseEvent, int n) {
                Vector vector = null;
                GlyphComponent glyphComponent = GlyphComponent.this;
                synchronized (glyphComponent) {
                    vector = (Vector)GlyphComponent.this.glyphSelectionListener.clone();
                }
                Point point = mouseEvent.getPoint();
                Vector vector2 = new Vector();
                Iterator iterator = GlyphComponent.this.first.getObjectsAt(point).iterator();
                while (iterator.hasNext()) {
                    vector2.add(iterator.next());
                }
                if (vector2.isEmpty()) {
                    return;
                }
                GlyphSelectionEvent glyphSelectionEvent = new GlyphSelectionEvent(GlyphComponent.this, mouseEvent, n, vector2);
                Iterator iterator2 = ((AbstractList)vector).iterator();
                while (iterator2.hasNext()) {
                    GlyphSelectionListener glyphSelectionListener = (GlyphSelectionListener)iterator2.next();
                    glyphSelectionListener.selection(glyphSelectionEvent);
                }
            }
        });
    }

    public GlyphComponent(Component component) {
        this();
        this.setRoot(component);
    }

    public void resize() {
        Rectangle2D rectangle2D = this.first.getBounds().getBounds2D();
        Dimension dimension = new Dimension((int)rectangle2D.getMaxX(), (int)rectangle2D.getMaxY());
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
    }

    public synchronized void addGlyphSelectionListener(GlyphSelectionListener glyphSelectionListener) {
        this.glyphSelectionListener.add(glyphSelectionListener);
    }

    public synchronized void removeGlyphSelectionListener(GlyphSelectionListener glyphSelectionListener) {
        this.glyphSelectionListener.remove(glyphSelectionListener);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = this.getBounds();
        graphics2D.clearRect((int)rectangle.getMinX(), (int)rectangle.getMinY(), (int)((RectangularShape)rectangle).getWidth(), (int)((RectangularShape)rectangle).getHeight());
        this.first.paint(graphics2D);
    }

    public Dimension getPreferredScrollableViewportSize() {
        System.out.println("Got preferred size " + this.getPreferredSize());
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return (int)rectangle.getWidth() - 10;
        }
        return (int)rectangle.getHeight() - 10;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public static interface Constraint {
        public AffineTransform calculateTransform(Rectangle2D var1, Rectangle2D var2);
    }
}

