## ----setup, include=FALSE,echo=FALSE------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    cache = TRUE,
    out.width = "100%"
)

## ----install, eval=FALSE------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("BiocMaintainerApp")

## ----load, include=TRUE,results="hide",message=FALSE,warning=FALSE------------
library(BiocMaintainerApp)

## ----launch, eval=FALSE-------------------------------------------------------
# BiocMaintainerShiny()

## ----overviewpic, echo=FALSE--------------------------------------------------
knitr::include_graphics("figures/BiocMaintainerShiny.png")

## ----filterpic, echo=FALSE----------------------------------------------------
knitr::include_graphics("figures/FilterEmail.png")

## ----searchpic, echo=FALSE----------------------------------------------------
knitr::include_graphics("figures/FilterSearchBox.png")

## ----optcolpic, echo=FALSE----------------------------------------------------
knitr::include_graphics("figures/OptionalColumns.png")

## ----sessioninfo--------------------------------------------------------------
sessionInfo()

