## ----style, echo=FALSE, results='hide', message=FALSE-------------------------
BiocStyle::markdown()

## ----package_install, eval=FALSE, message=FALSE, warning=FALSE----------------
# if (!require("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# if (!require("MDSvis", quietly = TRUE))
#     BiocManager::install("MDSvis")

## ----rlibs, results=FALSE, message=FALSE, warning=FALSE-----------------------
library(CytoMDS)
library(MDSvis)

## ----loadDataSet--------------------------------------------------------------
# inputs
inputDir <- system.file("extdata", package = "MDSvis")
distPath <- file.path(inputDir, "fsap_mature_226_distances.txt")
propPath <- file.path(inputDir, "fsap_mature_226_properties.txt")

# reading distance matrix from disk
distData <- read.delim(distPath)
rownames(distData) <- distData$X
distData$X <- NULL
distMat <- as.matrix(distData)

# reading properties
propDF <- read.delim(propPath)

## ----convertPhenoData---------------------------------------------------------
# split properties between factors and continuous variables (stats)

statMat <- as.matrix(propDF[, -1])
statList <- list(quant_properties = statMat)

propDF <- propDF[, 1, drop = FALSE]
propDF$family <- factor(substr(propDF$Sequence_Name, start = 1, stop = 3))
propDF$genus <- factor(substr(propDF$Sequence_Name, start = 1, stop = 6))
propDF$species <- factor(substr(propDF$Sequence_Name, start = 1, stop = 8))

## ----tables-------------------------------------------------------------------
table(propDF$family)
table(propDF$genus)
table(propDF$species)

## ----MDSCalc------------------------------------------------------------------
MDSObj <- CytoMDS::computeMetricMDS(pwDist = distMat, 
                                    nDim = 10)

show(MDSObj)

## ----saveRDS, eval=FALSE------------------------------------------------------
# # outputs (for shiny app)
# MDSRDSPath <- "fsap_mature_MDS.rds"
# statRDSPath <- "fsap_mature_stats.rds"
# propRDSPath <- "fsap_mature_props.rds"
# 
# # saving objects
# saveRDS(MDSObj, file = MDSRDSPath)
# saveRDS(statList, file = statRDSPath)
# saveRDS(propDF, file = propRDSPath)

## ----launch,eval=FALSE--------------------------------------------------------
# MDSvis::mdsvis_app()

## ----sessioninfo, echo=FALSE--------------------------------------------------
sessionInfo()

