## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE)

## ----style, echo=FALSE, results='asis'----------------------------------------
BiocStyle::markdown()

## ----echo = TRUE, eval = FALSE------------------------------------------------
# library("SmartPhos")
# runSmartPhos()

## ----echo = TRUE, eval = FALSE------------------------------------------------
# library("SmartPhos")
# makeSmartPhosDirectory(path = "shinyApp")

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "firstLook.png"))

## ----out.width = "400px"------------------------------------------------------
knitr::include_graphics(file.path("images", "preprocess1.png"))

## ----out.width = "600px"------------------------------------------------------
knitr::include_graphics(file.path("images", "preprocess2.png"))

## ----out.width = "350px"------------------------------------------------------
knitr::include_graphics(file.path("images", "preprocess3.png"))

## ----out.width = "350px"------------------------------------------------------
knitr::include_graphics(file.path("images", "preprocess4.png"))

## ----out.width = "350px"------------------------------------------------------
knitr::include_graphics(file.path("images", "error1.png"))

## ----out.width = "350px"------------------------------------------------------
knitr::include_graphics(file.path("images", "error2.png"))

## ----out.width = "350px"------------------------------------------------------
knitr::include_graphics(file.path("images", "error3.png"))

## ----out.width="400px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "preprocess.png"))

## ----out.width="300px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "otherOptions1.png"))

## ----out.width="600px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "otherOptions2.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(c(file.path("images", "boxPlot.png"), 
                          file.path("images", "logRatio.png") ,
                          file.path("images", "table.png"),
                          file.path("images", "completeness.png")))

## ----out.width="300px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "pca1.png"))

## ----out.width="300px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "pca2.png"))

## ----out.width="490px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "pca3.png"))

## ----out.width="600px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "pca4.png"))

## ----out.width="600px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "pca5.png"))

## ----out.width="500px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "heatmap.png"))

## ----out.width="300px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "heatmapPDF.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(c(file.path("images", "heatmap1.png"), 
                          file.path("images", "heatmap2.png")))

## ----out.width="400px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "errorHeatmap.png"))

## ----out.width="350px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "diff_option1.png"))

## ----out.width="350px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "diff_option2.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "diff.png"))

## ----out.width="300px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "diff_filter.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "diff_click.png"))

## ----out.width="400px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "errorDEA.png"))

## ----out.width="350px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "timeSeriesOptions.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "timeSeriesClust1.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "timeSeriesClust2.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "time_series_result2.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "time_series_result3.png"))

## ----out.width="300px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "clustering0.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "clustering1.png"))
knitr::include_graphics(file.path("images", "clustering2.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "timeSeriesErr1.png"))

## ----out.width="350px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "enrich_option.png"))

## ----out.width="300px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "enrich_err1.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "enrich_result1.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "enrich_resultTS.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "enrich_result1_Phospho.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "enrich_result2_Phospho.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "enrich_result2.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "enrich_result3.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "enrich_result4.png"))
knitr::include_graphics(file.path("images", "enrich_result5.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "enrich_result6.png"))
knitr::include_graphics(file.path("images", "enrich_result7.png"))

## ----out.width="300px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "kinase_settings1.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "kinase_result1.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "kinase_result2.png"))

## ----out.width="300px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "kinase_settings2.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "kinase_result3.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "kinase_result4.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "kinase_result5.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "kinase_err1.png"))

## ----out.width="300px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "kinase_settings3.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "kinase_result6.png"))

## ----out.width="300px"--------------------------------------------------------
knitr::include_graphics(file.path("images", "kinase_result7.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "kinase_result8.png"))

## -----------------------------------------------------------------------------
knitr::include_graphics(file.path("images", "log_info.png"))

## -----------------------------------------------------------------------------
sessionInfo()

