% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{signatureHeatmaps}
\alias{signatureHeatmaps}
\title{Heatmap function to dissect one pathway signature}
\usage{
signatureHeatmaps(
  pathway,
  bsrdm,
  bsrsig,
  heights = c(4, 2, 4),
  fontsize = 6,
  legend.fontsize = 8,
  title.fontsize = 8,
  col.fontsize = 6,
  annot.fontsize = 8,
  ht.gap = 3,
  show_column_names = TRUE
)
}
\arguments{
\item{pathway}{The chosen pathway name.}

\item{bsrdm}{BulkSignalR data model object.}

\item{bsrsig}{BulkSignalR signature object.}

\item{heights}{A vector of 3 heights (in cm) for the 3 heatmaps.}

\item{fontsize}{Font size for the gene names.}

\item{legend.fontsize}{Font size for the legends.}

\item{title.fontsize}{Font size for the pathway name as plot title.}

\item{col.fontsize}{Font size for column (sample) names.}

\item{annot.fontsize}{Font size for column annotation names.}

\item{ht.gap}{Space between heatmaps (in mm).}

\item{show_column_names}{Add column names in the heatmaps.}
}
\value{
A plot is created.
}
\description{
Plots a stack of three heatmaps to assess the expression of
the target genes or proteins in a chosen pathway, the receptor expressions,
and the ligand expressions.
}
\examples{
data(bsrdm, package = "BulkSignalR")
data(bsrinf, package = "BulkSignalR")
if(FALSE){
bsrinf.redP <- reduceToPathway(bsrinf)
bsrinf.redPBP <- reduceToBestPathway(bsrinf)
bsrsig.redPBP <- BSRSignature(bsrinf, qval.thres = 1)
pathway1 <- pathways(bsrsig.redPBP)[1]
signatureHeatmaps(
pathway = pathway1,
bsrdm = bsrdm,
bsrsig = bsrsig.redPBP,
show_column_names = TRUE)
}
}
