% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadVCFs.R
\name{auxProcessVariants}
\alias{auxProcessVariants}
\title{auxProcessVariants}
\usage{
auxProcessVariants(
  vars,
  cnvGR,
  heterozygous.range,
  homozygous.range,
  min.total.depth,
  exclude.indels,
  regions.to.exclude
)
}
\arguments{
\item{vars}{\code{GRanges} object containing variants for a certain sample.}

\item{cnvGR}{\code{GRanges} object containg CNV calls for a certain sample.}

\item{heterozygous.range}{Heterozygous range. Variants not in the homozygous/heterozygous intervals will be excluded.}

\item{homozygous.range}{Homozygous range. Variants not in the homozygous/heterozygous intervals will be excluded.}

\item{min.total.depth}{Minimum total depth. Variants under this value will be excluded.}

\item{exclude.indels}{Whether to exclude indels when loading the variants. TRUE is the recommended value given that indels frequency varies in a different way than SNVs.}

\item{regions.to.exclude}{A \code{GRanges} object defining the regions for which the variants should be excluded.}
}
\value{
Processed \code{vars}
}
\description{
Auxiliar function called by \code{loadVCFs} to process variants
}
