% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAllCNVs.R
\name{plotAllCNVs}
\alias{plotAllCNVs}
\title{plotAllCNVs}
\usage{
plotAllCNVs(cnvs.gr, genome = "hg19")
}
\arguments{
\item{cnvs.gr}{\code{GRanges} containing al CNV definitions returned by \code{filterCNVs} or \code{loadCNVcalls} functions.}

\item{genome}{The name of the genome. (Defaults to "hg19")}
}
\value{
invisibly returns a \code{karyoplot} object
}
\description{
Plots all CNVs on chromosome ideograms
}
\details{
Plots all CNVs defined at \code{cnvs.gr} on a view of horizontal ideograms representing all chromosomes.
}
\examples{
cnvs.file <- system.file("extdata", "DECoN.CNVcalls.2.csv", package = "CNVfilteR", mustWork = TRUE)
cnvs.gr <- loadCNVcalls(cnvs.file = cnvs.file, chr.column = "Chromosome", start.column = "Start", end.column = "End", cnv.column = "CNV.type", sample.column = "Sample")

# Plot all CNVs
plotAllCNVs(cnvs.gr)


}
