% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeneAnnotation.R
\name{getNearbyGenes}
\alias{getNearbyGenes}
\title{Nearby genes}
\usage{
getNearbyGenes(
  fPrime,
  geneSet,
  radius,
  metric = "umap",
  numPCs = NULL,
  weights = FALSE
)
}
\arguments{
\item{fPrime}{\itemize{
\item a Seurat object of genes or
SingleCellExperiment to be converted to a Seurat object
}}

\item{geneSet}{\itemize{
\item set of genes
}}

\item{radius}{\itemize{
\item the distance around the given set
}}

\item{metric}{\itemize{
\item the metric to use, one of umap, tsne,
pca or nearest neighbor
}}

\item{numPCs}{\itemize{
\item used only if the metric is pca
}}

\item{weights}{\itemize{
\item whether to use edge weights in the NN case
}}
}
\value{
This returns a named vector whose values are distance
from geneSet and whose names are the nearby genes.
}
\description{
This finds the genes near a give subset using either
a dimensional reduction or the nearest neighbor graph
}
\examples{
getExample = make.getExample()
STranspose = getExample('STranspose',toy=TRUE)
hallmark = getExample('hallmark')
geneSet = intersect(colnames(STranspose),hallmark[["HALLMARK_TNFA_SIGNALING_VIA_NFKB"]])
geometricallyNearby = getNearbyGenes(STranspose,geneSet,radius=0.2,metric='umap')
combinatoriallyNearby = getNearbyGenes(STranspose,geneSet,radius=1,metric='NN')
weightedNearby = getNearbyGenes(STranspose,'Myc',radius=1,metric='NN',weights=TRUE)
}
