% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellMentor-package.R, R/GridSearch.R
\docType{package}
\name{CellMentor}
\alias{CellMentor}
\alias{CellMentor-package}
\title{CellMentor: Cell-Type Aware Dimensionality Reduction for Single-Cell RNA-Seq}
\usage{
CellMentor(
  object,
  k = NULL,
  init_methods = c("regulated"),
  alpha_range = c(1, 5),
  beta_range = c(1, 5),
  gamma_range = c(0.1),
  delta_range = c(1),
  n_iter = 1,
  verbose = TRUE,
  num_cores = 1,
  seed = 1
)
}
\arguments{
\item{object}{CSFNMF object containing reference and query data matrices,
with required matrices
for \code{data} and \code{ref} under \code{object@matrices}.}

\item{k}{Optional rank value (number of factors). If \code{NULL}:
- Uses existing rank from \code{object} if available
- Otherwise determines automatically using \code{SelectRank}}

\item{init_methods}{Vector of initialization methods to test. Options:
- "uniform": Random uniform initialization
- "regulated": Cell-type guided initialization
- "NNDSVD": Non-negative Double SVD
- "skmeanGenes": Gene clustering-based
- "skmeanCells": Cell clustering-based
Default: c("regulated")}

\item{alpha_range}{Vector of \code{alpha} values to test.
Controls within-class scatter (cell similarity within
the same type).
Default: c(0.1, 0.5, 1)}

\item{beta_range}{Vector of \code{beta} values to test.
Controls between-class scatter (cell separation between
different types).
Default: c(1, 2, 5)}

\item{gamma_range}{Vector of sparsity parameter values to test.
Controls sparsity of the factorization.
Default: c(0, 0.1)}

\item{delta_range}{Vector of orthogonality parameter values to test.
Controls orthogonality between factors.
Default: c(0, 0.5)}

\item{n_iter}{Number of repetitions per configuration for averaging
results (default: 3).}

\item{verbose}{Logical; whether to show progress messages during
optimization.
Default: \code{TRUE}}

\item{num_cores}{Number of cores to use for parallel processing.
If > 1, parameter combinations are tested in parallel.
Default: 1}

\item{seed}{Random seed}
}
\value{
List containing:
- \code{best_params}: List with the overall best parameter configuration:
* \code{k}: Selected rank
* \code{init_method}: Best initialization method
* \code{alpha}: Best alpha parameter
* \code{beta}: Best beta parameter
* \code{gamma}: Best gamma value
* \code{delta}: Best delta value
* \code{accuracy}: Best achieved accuracy
* \code{loss}: Corresponding loss value
- \code{results}: Data frame of all combinations tested, including:
* \code{init_method}: Initialization method used
* \code{alpha}: Alpha parameter value
* \code{beta}: Beta parameter value
* \code{gamma}: Gamma parameter value
* \code{delta}: Delta parameter value
* \code{accuracy}: Achieved accuracy
* \code{loss}: Final loss value
* \code{convergence_iter}: Number of iterations for convergence
- \code{best_model}:CSFNMF model object trained with the best parameters.
}
\description{
CellMentor is a supervised dimensionality reduction method based on
non-negative matrix factorization (NMF) that integrates cell type labels
directly into its optimization objective. By minimizing variation within
known populations while maximizing distinctions between types, CellMentor
produces low-dimensional embeddings optimized for cell type identification
in single-cell RNA sequencing analysis.

Tests different combinations of hyperparameters using \code{RunCSFNMF}
to find the optimal configuration.
The function performs a grid search over specified parameter ranges,
evaluating the model's
performance for each combination. Parameters \code{alpha} and \code{beta} are
kept equal during optimization.
The rank (\code{k}) can be provided, taken from an existing object, or
determined automatically using
\code{SelectRank}.
}
\section{Key Features}{

\itemize{
\item \strong{Supervised NMF Framework:} Incorporates labels via discriminative constraints
\item \strong{Superior Cell Type Separation:} Maximally separable embeddings
\item \strong{Robust Batch Handling:} Preserves biology while mitigating technical effects
\item \strong{Rare Population Detection:} Sensitive to low-frequency types
\item \strong{Automated Parameter Optimization:} Built-in hyperparameter tuning
}
}

\section{Two-Phase Workflow}{

\enumerate{
\item \strong{Decomposition (Training):} Learn W (genes × K) and H (K × cells)
\item \strong{Projection (Inference):} Project queries with non-negative least squares
}
}

\section{Main Functions}{

\itemize{
\item \code{\link{CellMentor}} — supervised NMF / hyperparameter search
\item \code{\link{project_data}} — project queries using learned W
\item \code{\link{CreateCSFNMFobject}} — initialize a CellMentor object
}
}

\section{Getting Help}{

\itemize{
\item Package docs: \code{help(package = "CellMentor")}
\item GitHub: \url{https://github.com/petrenkokate/CellMentor}
\item Issues: \url{https://github.com/petrenkokate/CellMentor/issues}
}
}

\examples{
data(obj_toy, package = "CellMentor")
# Run lightweight CellMentor
result <- CellMentor(
  object        = obj_toy,
  k             = 2,
  init_methods  = "regulated",
  alpha_range   = 1,
  beta_range    = 1,
  gamma_range   = 0.1,
  delta_range   = 1,
  n_iter        = 1,
  verbose       = FALSE,
  num_cores     = 1
)

# Inspect results (should run in <10 seconds)
names(result)
if ("best_params" \%in\% names(result)) {
  print(result$best_params)
}
}
\references{
Hevdeli, O., Petrenko, E., & Aran, D. (2025). CellMentor: Cell-Type Aware
Dimensionality Reduction for Single-cell RNA-Sequencing Data. \emph{bioRxiv}.
\doi{10.1101/2025.06.17.660094}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/petrenkokate/CellMentor}
  \item Report bugs at \url{https://github.com/petrenkokate/CellMentor/issues}
}

}
\author{
Or Hevdeli (equal contribution) \cr
Ekaterina Petrenko (equal contribution) \email{petrenko.kate@icloud.com} \cr
Dvir Aran (corresponding author) \email{dviraran@technion.ac.il}
}
