% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_object.R
\name{CreateCSFNMFobject}
\alias{CreateCSFNMFobject}
\title{Create CSFNMF Object for Cell Type Analysis}
\usage{
CreateCSFNMFobject(
  ref_matrix,
  ref_celltype,
  data_matrix,
  norm = TRUE,
  most.variable = TRUE,
  scale = TRUE,
  scale_by = "cells",
  gene_list = NULL,
  verbose = TRUE,
  num_cores = 1
)
}
\arguments{
\item{ref_matrix}{Reference matrix (genes × cells) with known cell types}

\item{ref_celltype}{Vector of cell type labels for reference cells}

\item{data_matrix}{Query matrix (genes × cells) to be analyzed}

\item{norm}{Logical: perform normalization (default: TRUE)}

\item{most.variable}{Logical: select variable genes (default: TRUE)}

\item{scale}{Logical: perform scaling (default: TRUE)}

\item{scale_by}{Character: scaling method, either "cells" or "genes"
(default: "cells")}

\item{gene_list}{Optional vector of genes to include (default: NULL)}

\item{verbose}{Logical: show progress messages (default: TRUE)}

\item{num_cores}{Integer: number of cores for parallel processing
(default: 1)}
}
\value{
A CSFNMF object containing processed data and annotations
}
\description{
Creates and initializes a Constrained Supervised Factorization NMF
(CSFNMF) object
for analyzing single-cell RNA sequencing data. This is the main function for
starting analysis with CellMentor.
}
\examples{
data(ref_matrix_toy, qry_matrix_toy, ref_celltype_toy, package = "CellMentor")
obj <- CreateCSFNMFobject(ref_matrix_toy, ref_celltype_toy, qry_matrix_toy,
                          norm = FALSE, most.variable = FALSE, scale = FALSE,
                          verbose = FALSE, num_cores = 1)
inherits(obj, "csfnmf")
}
