% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Datasets.R
\name{muraro_dataset}
\alias{muraro_dataset}
\title{Load Muraro Pancreas Dataset}
\usage{
muraro_dataset()
}
\value{
A list containing:
\item{data}{Expression matrix with genes as rows and cells as columns}
\item{celltypes}{Named vector of cell type annotations}
}
\description{
Loads and processes the Muraro et al. pancreas single-cell RNA-seq dataset
}
\examples{

# Load Muraro pancreas dataset
muraro <- muraro_dataset()

# Check dataset dimensions
dim(muraro$data)

# View available cell types
table(muraro$celltypes)

# Check number of cells per type
sort(table(muraro$celltypes), decreasing = TRUE)


}
