% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readRules.R
\name{build_sif_table_from_rule}
\alias{build_sif_table_from_rule}
\title{Build a SIF table from a logic rule written in a string}
\usage{
build_sif_table_from_rule(rule_str, target, last_and_num = 0)
}
\arguments{
\item{rule_str}{String containing the rule to be parsed}

\item{target}{Name of the node affected by the rule}

\item{last_and_num}{If the rule contains `and` gates, their numeration will start after the number provided here (default is 0)}
}
\value{
data.frame with the network structure derived from the rule.
The column `sif_str` contains the string that can be written to a file 
and then read with `readSIF()` in order to load a CellNOpt compatible network.
}
\description{
Build a SIF table from a logic rule written in a string
}
\examples{
CellNOptR:::build_sif_table_from_rule("B & (C | D)", "A", last_and_num=2)

test_rule <- list()
test_rule[[1]] <- "AMP_ATP | (ATM & ATR) | HIF1 | !(EGFR | FGFR3)"
test_rule[[2]] <- "A & ((B | C) & !(D & E))"
test_rule[[3]] <- "A & B | C"
test_rule[[4]] <- "A & B & C"
test_rule[[5]] <- "A & (B | C)"
test_rule[[6]] <- "(A | B) & (C | D)"
test_rule[[7]] <- "!(C & D) | (E & F)"
test_rule[[8]] <- "(A | B) & (C | !D) & (E | F)"
parsed_rule <- list()
for (i in c(1:length(test_rule))){
  parsed_rule[[i]] <- CellNOptR:::build_sif_table_from_rule(test_rule[[i]], "T")
}

}
