% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoSIA-plots-method.R
\name{plotCVGEx,CoSIAn-method}
\alias{plotCVGEx,CoSIAn-method}
\title{plotCVGEx Method}
\usage{
\S4method{plotCVGEx}{CoSIAn}(object)
}
\arguments{
\item{object}{CoSIAn object with all user accessible slots filled in as well
as the converted_id and metric slot filled}
}
\value{
plot object
}
\description{
plotCVGEx Method
}
\examples{
Kidney_Genes <- CoSIAn(
    gene_set = c("ENSG00000008710", "ENSG00000118762", "ENSG00000152217"),
    i_species = "h_sapiens", input_id = "Ensembl_id", o_species = c(
        "h_sapiens", "r_norvegicus"
    ), output_ids = c("Ensembl_id", "Symbol"),
    mapping_tool = "annotationDBI", ortholog_database = "HomoloGene",
    map_tissues = c("adult mammalian kidney","heart"), 
    map_species = c("h_sapiens", "r_norvegicus"),
    metric_type = "CV_Tissue"
)
Kidney_gene_conversion <- CoSIA::getConversion(Kidney_Genes)
Kidney_gene_metric <- getGExMetrics(Kidney_gene_conversion)
plot <- plotCVGEx(Kidney_gene_metric)
}
\references{
Dot plot in R with the dotchart function [with examples]. 
R CODER. (2020, November 20). Retrieved from https://r-coder.com/dot-plot-r/
}
