% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onlyInOneLabelState.R
\name{onlyInOneLabelState}
\alias{onlyInOneLabelState}
\title{Report Proteins Present In Only One Label State}
\usage{
onlyInOneLabelState(.data)
}
\arguments{
\item{.data}{An environment containing dataframes}
}
\value{
a list with 3 items, each item is a vector containing names
belonging to one of 3 groups
}
\description{
This function returns NAMES of proteins present in only labelled/only 
unlabelld or both label states
}
\examples{

##Use example peptide data set, read in and clean data
inputFile <- system.file("extData", "data.txt", package = "ComPrAn")
peptides <- peptideImport(inputFile)
peptides <- cleanData(peptides, fCol = "Search ID")
## separate chemical modifications and labelling into separate columns
peptides <- splitModLab(peptides) 
## remove unneccessary columns, simplify rows
peptides <- simplifyProteins(peptides) 
## Pick representative peptide for each protein for both scenarios
peptide_index <- pickPeptide(peptides)
## extract list of names of proteins present in one/both samples
oneStateList <- onlyInOneLabelState(peptide_index)
}
