% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompensAID.R
\name{CompensAID}
\alias{CompensAID}
\title{CompensAID}
\usage{
CompensAID(ff, segment.value = 4, events.value = 50)
}
\arguments{
\item{ff}{(FlowFrame): FlowFrame containing the expression matrix, channel names, and marker names.}

\item{segment.value}{(numerical): Numerical value of the number of segments in the primary positive population.}

\item{events.value}{(numerical): Numerical value of the minimum number of events per population/segment.}
}
\value{
(list) Returns a list containing the full SSI output and SSI matrix
}
\description{
Run CompensAID to assess the potential presence of reference errors within the FCS file. The outcome is a list which contains an SSI matrix. The matrix quickly visualizes the marker combinations for each marker combinations. Additional information regarding the number of events per segments, which segments were merged, and the corresponding SSI values can be found in the Info dataframe.
}
\examples{
# Import FCS file
file <- flowCore::read.FCS(system.file("extdata", "68983.fcs", package = "CompensAID"))

# Run CompensAID tool
compensAID.res <- CompensAID(ff = file)

}
