% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set2DF.R
\name{set2DF}
\alias{set2DF}
\title{convert a flowSet to a data frame}
\usage{
set2DF(flowSet, fcsFiles, y = NULL)
}
\arguments{
\item{flowSet}{A flowSet object}

\item{fcsFiles}{A vector containing the name of each fcs file included in
flowSet.}

\item{y}{The clinical outcome each fcs file associated with. Null for testing
data.}
}
\value{
Returns a data frame containing the cytometry data. Cells from
  different fcs files are combined into one flow frame. A new column,
  xSample, is introduced to indicate the origin of each cell. The data frame
  also includes the clinical outcome y.
}
\description{
A function that convert a flowSet to a data frame.
}
\examples{
library(flowCore)
# Find the table containing fcs file names in CytoDx package
path <- system.file("extdata",package="CytoDx")
# read the table
fcs_info <- read.csv(file.path(path,"fcs_info.csv"))
# Specify the path to the cytometry files
fn <- file.path(path,fcs_info$fcsName)
fSet <- read.flowSet(fn)
df <- set2DF(flowSet=fSet,fcsFiles=fn,y = fcs_info$Label)
}
