% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoPipeline-package.R
\docType{package}
\name{CytoPipeline}
\alias{CytoPipeline-package}
\alias{CytoPipeline}
\title{CytoPipeline package}
\description{
\code{CytoPipeline} is a package that provides support for automation and
visualization of flow cytometry data analysis pipelines. In the current
state, the package focuses on the preprocessing and quality control part.

The framework is based on two main S4 classes, i.e. \code{CytoPipeline} and
\code{CytoProcessingStep}. The \code{CytoProcessingStep} defines the link between
pipeline step names and corresponding R functions that are either provided
in the CytoPipeline package itself, or exported from a third party package,
or coded by the user her/himself. The processing steps need to be specified
centrally and explicitly using either a json input file or through
step by step creation of a \code{CytoPipeline} object with dedicated methods.

After having run the pipeline, obtained results at all steps
can be retrieved and visualized thanks to file caching
(the running facility uses a \code{BiocFileCache} implementation).
The package provides also specific visualization tools like
pipeline workflow summary display, and 1D/2D comparison plots
of obtained flowFrames at various steps of the pipeline.

For a step by step example using \code{CytoPipeline}, please have a look
at the vignette!
}
\seealso{
\link{CytoPipelineClass}, \link{CytoProcessingStep}
}
\author{
\strong{Maintainer}: Philippe Hauchamps \email{philippe.hauchamps@uclouvain.be} (\href{https://orcid.org/0000-0003-2865-1852}{ORCID})

Authors:
\itemize{
  \item Laurent Gatto \email{laurent.gatto@uclouvain.be} (\href{https://orcid.org/0000-0002-1520-2268}{ORCID})
}

Other contributors:
\itemize{
  \item Dan Lin \email{dan.8.lin@gsk.com} [contributor]
}

}
\keyword{internal}
